/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.validation;

import com.togethersoft.togetherxj.uml.cdl.CdlPlugin;
import com.togethersoft.togetherxj.uml.cdl.validation.IActionValidator;
import com.togethersoft.togetherxj.uml.cdl.validation.IActionValidatorParameters;
import com.togethersoft.togetherxj.uml.cdl.validation.ValidatorStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;

public class ActionValidators {
    private static final String EXTENSIONPOINT_ID = "action-validators";
    private static final String VALIDATOR_TAG = "validator";
    private static final String VALIDATOR_CLASS_ATTR = "class";
    private static final String VALIDATOR_ACTION_ID_ATTR = "actionId";
    private static final HashMap myValidatrosMap = new HashMap();

    private ActionValidators() {
    }

    protected static void parseExtensions() {
        IPluginDescriptor iPluginDescriptor = CdlPlugin.getDefault().getDescriptor();
        IExtensionPoint iExtensionPoint = iPluginDescriptor.getExtensionPoint(EXTENSIONPOINT_ID);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals(VALIDATOR_TAG)) {
                    try {
                        IActionValidator iActionValidator = (IActionValidator)iConfigurationElement.createExecutableExtension(VALIDATOR_CLASS_ATTR);
                        String string = iConfigurationElement.getAttribute(VALIDATOR_ACTION_ID_ATTR);
                        if (string != null && string.length() > 0) {
                            ArrayList<IActionValidator> arrayList = (ArrayList<IActionValidator>)myValidatrosMap.get(string);
                            if (arrayList == null) {
                                arrayList = new ArrayList<IActionValidator>();
                                myValidatrosMap.put(string, arrayList);
                            }
                            System.out.println("ActionValidators.parseExtensions add actionId:" + string + " validator:" + iActionValidator);
                            arrayList.add(iActionValidator);
                        }
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        noClassDefFoundError.printStackTrace();
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public static Iterator validators(String string) {
        Object v = myValidatrosMap.get(string);
        if (v instanceof Collection) {
            return ((Collection)v).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public static IStatus preValidateAction(String string, IActionValidatorParameters iActionValidatorParameters) {
        Iterator iterator = ActionValidators.validators(string);
        while (iterator.hasNext()) {
            IActionValidator iActionValidator = (IActionValidator)iterator.next();
            IStatus iStatus = iActionValidator.preValidateAction(string, iActionValidatorParameters);
            if (iStatus.isOK()) continue;
            return iStatus;
        }
        return ValidatorStatus.OK_STATUS;
    }

    public static IStatus postValidateAction(String string, IActionValidatorParameters iActionValidatorParameters) {
        Iterator iterator = ActionValidators.validators(string);
        while (iterator.hasNext()) {
            IActionValidator iActionValidator = (IActionValidator)iterator.next();
            IStatus iStatus = iActionValidator.postValidateAction(string, iActionValidatorParameters);
            if (iStatus.isOK()) continue;
            return iStatus;
        }
        return ValidatorStatus.OK_STATUS;
    }

    static {
        ActionValidators.parseExtensions();
    }
}

