/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.util;

import com.togethersoft.togetherxj.uml.cdl.util.Assert;
import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Link;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.Enumeration;

public class ModelElementUtil {
    public static final String SOURCE_ROLE = "Client";
    public static final String TARGET_ROLE = "Supplier";

    public static Element findElement(Model model, String string) {
        Enumeration enumeration;
        UniqueName uniqueName = ModelAccess.createUniqueName((String)string);
        Assert.assertNotNull("Can't create proper unique name from string: " + string, uniqueName);
        if (model != null && (enumeration = model.findElement(uniqueName)) != null) {
            return enumeration;
        }
        enumeration = ModelAccess.models();
        while (enumeration.hasMoreElements()) {
            Element element = ((Model)enumeration.nextElement()).findElement(uniqueName);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public static Entity getLinkTarget(Entity entity) {
        ElementEnumeration elementEnumeration = entity.participants(TARGET_ROLE);
        if (elementEnumeration.hasMoreElements()) {
            Entity entity2 = (Entity)elementEnumeration.next();
            return entity2;
        }
        return null;
    }

    public static Entity getLinkSource(Entity entity) {
        ElementEnumeration elementEnumeration = entity.participants(SOURCE_ROLE);
        if (elementEnumeration.hasMoreElements()) {
            Entity entity2 = (Entity)elementEnumeration.next();
            return entity2;
        }
        return null;
    }

    public static Entity createLink(Entity entity, Entity entity2, String string) {
        Assert.assertNotNull("source is NULL!", entity);
        Assert.assertNotNull("target is NULL!", entity2);
        Assert.assertCanCreateChildEntity((Container)entity, string);
        Entity entity3 = entity.createChildEntity(string, null);
        Assert.assertNotNull("child link wasn't created", entity3);
        Assert.assertCanSetParticipant((Link)entity3, SOURCE_ROLE, null, (Element)entity);
        entity3.setParticipant(SOURCE_ROLE, null, (Element)entity);
        Assert.assertCanSetParticipant((Link)entity3, TARGET_ROLE, null, (Element)entity2);
        entity3.setParticipant(TARGET_ROLE, null, (Element)entity2);
        return entity3;
    }

    public static boolean hasJavaNature(Element element) {
        PropertyEnumeration propertyEnumeration = element.getModel().properties("$nature");
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            String string = property.getValue();
            if (!"org.eclipse.jdt.core.javanature".equals(string)) continue;
            return true;
        }
        return false;
    }
}

