/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.property;

import com.togethersoft.togetherxj.uml.cdl.core.ObjectClassHelper;
import com.togethersoft.togetherxj.uml.cdl.ui.CdlMessages;
import com.togethersoft.togetherxj.uml.cdl.ui.property.ObjectClassPropertySource;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.ui.property.element.EntityProperty;
import org.eclipse.jdt.core.IType;

public class ObjectClassProperty
extends EntityProperty {
    private ObjectClassPropertySource myPropertySource;

    public void setObjects(Object[] objectArray) {
        super.setObjects(objectArray);
        this.reinit();
    }

    private void reinit() {
        this.myPropertySource = new ObjectClassPropertySource((Entity)this.getObject(), null);
    }

    protected ObjectClassPropertySource getPropertySource() {
        return this.myPropertySource;
    }

    public Object getValue() {
        Object object;
        IType iType = null;
        Entity entity = (Entity)this.getObject();
        if (entity != null && (object = ObjectClassHelper.getInstantiatedClass(entity)) != null) {
            iType = JavaElementUtil.model2javaType((Element)object);
        }
        object = this.getPropertySource();
        ((ObjectClassPropertySource)object).setObjectClass(iType);
        return object;
    }

    public String isValidValue(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof ObjectClassPropertySource)) {
            return CdlMessages.getString("ObjectClassProperty.It_should_be___ObjectClassPropertySource___value._1");
        }
        return null;
    }

    public void setValue(Object object) {
        this.myPropertySource = (ObjectClassPropertySource)object;
        Entity entity = (Entity)this.getObject();
        if (entity != null) {
            if (this.myPropertySource.getObjectClass() != null) {
                Element element = JavaElementUtil.javaType2model((Element)entity, this.myPropertySource.getObjectClass());
                ObjectClassHelper.setInstantiatedClass(entity, (Entity)element);
            } else {
                ObjectClassHelper.setInstantiatedClass(entity, null);
            }
        }
    }
}

