/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields;

import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.DialogField;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.StringDialogField$1;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.StringDialogField$TrimVerifyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringDialogField
extends DialogField {
    private String myText = "";
    private Text myTextControl;
    private ModifyListener myModifyListener;
    private boolean myAllowTerminalSpaces = true;
    private StringDialogField$TrimVerifyListener myTrimVerifyListener;

    public StringDialogField(Object object) {
        super(object);
    }

    public void setAllowTerminalSpaces(boolean bl) {
        this.myAllowTerminalSpaces = bl;
        if (bl) {
            this.installTrimVerifyListener();
        } else {
            this.uninstallTrimVerifyListener();
        }
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)DialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)StringDialogField.gridDataForText(n - 1));
        return new Control[]{label, text};
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForText(int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.myTextControl)) {
            this.myTextControl.setFocus();
            this.myTextControl.setSelection(0, this.myTextControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(Composite composite) {
        if (this.myTextControl == null) {
            this.assertCompositeNotNull(composite);
            this.myModifyListener = new StringDialogField$1(this);
            this.myTextControl = new Text(composite, 2052);
            this.myTextControl.setText(this.myText);
            this.myTextControl.setFont(composite.getFont());
            this.myTextControl.addModifyListener(this.myModifyListener);
            this.myTextControl.setEnabled(this.isEnabled());
            if (!this.myAllowTerminalSpaces) {
                this.installTrimVerifyListener();
            }
        }
        return this.myTextControl;
    }

    private void doModifyText(ModifyEvent modifyEvent) {
        if (this.isOkToUse((Control)this.myTextControl)) {
            this.myText = this.myTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.myTextControl)) {
            this.myTextControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String string) {
        this.myText = string;
        if (this.isOkToUse((Control)this.myTextControl)) {
            this.myTextControl.setText(string);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String string) {
        this.myText = string;
        if (this.isOkToUse((Control)this.myTextControl)) {
            this.myTextControl.removeModifyListener(this.myModifyListener);
            this.myTextControl.setText(string);
            this.myTextControl.addModifyListener(this.myModifyListener);
        }
    }

    protected void installTrimVerifyListener() {
        if (this.myTextControl != null && this.myTrimVerifyListener == null) {
            this.myTrimVerifyListener = new StringDialogField$TrimVerifyListener(this, null);
            this.myTextControl.addVerifyListener((VerifyListener)this.myTrimVerifyListener);
        }
    }

    protected void uninstallTrimVerifyListener() {
        if (this.myTextControl != null && this.myTrimVerifyListener != null) {
            this.myTextControl.removeVerifyListener((VerifyListener)this.myTrimVerifyListener);
            this.myTrimVerifyListener = null;
        }
    }

    static void access$000(StringDialogField stringDialogField, ModifyEvent modifyEvent) {
        stringDialogField.doModifyText(modifyEvent);
    }
}

