/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields;

import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.SWTUtil;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.DialogField;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.StringDialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class StringButtonDialogField
extends StringDialogField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel = "!Browse...!";
    private boolean fButtonEnabled = true;

    public StringButtonDialogField(Object object) {
        super(object);
    }

    public void setButtonLabel(String string) {
        this.fBrowseButtonLabel = string;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)DialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)StringDialogField.gridDataForText(n - 2));
        Button button = this.getChangeControl(composite);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(button, 1));
        return new Control[]{label, text, button};
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForButton(Button button, int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        gridData.heightHint = SWTUtil.getButtonHeigthHint(button, null);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button, null);
        return gridData;
    }

    public Button getChangeControl(Composite composite) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(composite);
            this.fBrowseButton = this.createChangeControl(composite);
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
        return this.fBrowseButton;
    }

    protected abstract Button createChangeControl(Composite var1);

    public void enableButton(boolean bl) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && bl);
        }
        this.fButtonEnabled = bl;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

