/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields;

import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.CheckboxDialogField$1;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.DialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class CheckboxDialogField
extends DialogField {
    private Button myCheckboxControl;
    private String myCheckboxText = "";
    private boolean mySelected;

    public CheckboxDialogField(Object object) {
        super(object);
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Button button = this.getCheckboxControl(composite);
        button.setLayoutData((Object)CheckboxDialogField.gridDataForButton(button, n));
        return new Control[]{button};
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected static GridData gridDataForButton(Button button, int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.myCheckboxControl)) {
            this.myCheckboxControl.setFocus();
        }
        return true;
    }

    public Button getCheckboxControl(Composite composite) {
        if (this.myCheckboxControl == null) {
            this.assertCompositeNotNull(composite);
            this.myCheckboxControl = new Button(composite, 32);
            this.myCheckboxControl.addSelectionListener((SelectionListener)new CheckboxDialogField$1(this));
            this.myCheckboxControl.setFont(composite.getFont());
            this.myCheckboxControl.setEnabled(this.isEnabled());
            this.myCheckboxControl.setText(this.myCheckboxText);
        }
        return this.myCheckboxControl;
    }

    private void doWidgetSelected(SelectionEvent selectionEvent) {
        Button button = (Button)selectionEvent.widget;
        this.mySelected = button.getSelection();
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.myCheckboxControl)) {
            this.myCheckboxControl.setEnabled(this.isEnabled());
        }
    }

    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSelected(boolean bl) {
        this.mySelected = bl;
        if (this.isOkToUse((Control)this.myCheckboxControl)) {
            this.myCheckboxControl.setSelection(bl);
        } else {
            this.dialogFieldChanged();
        }
    }

    public Label getLabelControl(Composite composite) {
        return null;
    }

    public String getLabelText() {
        return this.myCheckboxText;
    }

    public void setLabelText(String string) {
        this.myCheckboxText = string;
    }

    static void access$000(CheckboxDialogField checkboxDialogField, SelectionEvent selectionEvent) {
        checkboxDialogField.doWidgetSelected(selectionEvent);
    }
}

