/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields;

import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.ButtonGroupDialogField$1;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.DialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ButtonGroupDialogField
extends DialogField {
    private Composite fButtonComposite;
    private Button[] fButtons;
    private String[] fButtonNames;
    private boolean[] fButtonsSelected;
    private boolean[] fButtonsEnabled;
    private int fGroupBorderStyle;
    private int fGroupNumberOfColumns;
    private int fButtonsStyle;

    public ButtonGroupDialogField(Object object, int n, String[] stringArray, int n2) {
        this(object, n, stringArray, n2, 0);
    }

    public ButtonGroupDialogField(Object object, int n, String[] stringArray, int n2, int n3) {
        super(object);
        this.fButtonNames = stringArray;
        int n4 = stringArray.length;
        this.fButtonsSelected = new boolean[n4];
        this.fButtonsEnabled = new boolean[n4];
        int n5 = 0;
        while (n5 < n4) {
            this.fButtonsSelected[n5] = false;
            this.fButtonsEnabled[n5] = true;
            ++n5;
        }
        if (this.fButtonsStyle == 16) {
            this.fButtonsSelected[0] = true;
        }
        this.fGroupBorderStyle = n3;
        this.fGroupNumberOfColumns = n2 <= 0 ? n4 : n2;
        this.fButtonsStyle = n;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        if (this.fGroupBorderStyle == 0) {
            Label label = this.getLabelControl(composite);
            label.setLayoutData((Object)DialogField.gridDataForLabel(1));
            Composite composite2 = this.getSelectionButtonsGroup(composite);
            GridData gridData = new GridData();
            gridData.horizontalSpan = n - 1;
            composite2.setLayoutData((Object)gridData);
            return new Control[]{label, composite2};
        }
        Composite composite3 = this.getSelectionButtonsGroup(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        composite3.setLayoutData((Object)gridData);
        return new Control[]{composite3};
    }

    public int getNumberOfControls() {
        return this.fGroupBorderStyle == 0 ? 2 : 1;
    }

    private Button createSelectionButton(int n, Composite composite, SelectionListener selectionListener) {
        Button button = new Button(composite, this.fButtonsStyle | 0x4000);
        button.setFont(composite.getFont());
        button.setText(this.fButtonNames[n]);
        button.setEnabled(this.isEnabled() && this.fButtonsEnabled[n]);
        button.setSelection(this.fButtonsSelected[n]);
        button.addSelectionListener(selectionListener);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    public Composite getSelectionButtonsGroup(Composite composite) {
        if (this.fButtonComposite == null) {
            Object object;
            this.assertCompositeNotNull(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.makeColumnsEqualWidth = true;
            gridLayout.numColumns = this.fGroupNumberOfColumns;
            if (this.fGroupBorderStyle != 0) {
                object = new Group(composite, this.fGroupBorderStyle);
                String string = this.getLabelText();
                if (string != null && string.length() > 0) {
                    object.setText(string);
                }
                this.fButtonComposite = object;
            } else {
                this.fButtonComposite = new Composite(composite, 0);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
            }
            this.fButtonComposite.setLayout((Layout)gridLayout);
            object = new ButtonGroupDialogField$1(this);
            int n = this.fButtonNames.length;
            this.fButtons = new Button[n];
            int n2 = 0;
            while (n2 < n) {
                this.fButtons[n2] = this.createSelectionButton(n2, this.fButtonComposite, (SelectionListener)object);
                ++n2;
            }
            int n3 = n / this.fGroupNumberOfColumns;
            int n4 = n3 * this.fGroupNumberOfColumns - n;
            int n5 = 0;
            while (n5 < n4) {
                DialogField.createEmptySpace(this.fButtonComposite);
                ++n5;
            }
        }
        return this.fButtonComposite;
    }

    public Button getSelectionButton(int n) {
        if (n >= 0 && n < this.fButtons.length) {
            return this.fButtons[n];
        }
        return null;
    }

    private void doWidgetSelected(SelectionEvent selectionEvent) {
        Button button = (Button)selectionEvent.widget;
        int n = 0;
        while (n < this.fButtons.length) {
            if (this.fButtons[n] == button) {
                this.fButtonsSelected[n] = button.getSelection();
                this.dialogFieldChanged();
                return;
            }
            ++n;
        }
    }

    public boolean isSelected(int n) {
        if (n >= 0 && n < this.fButtonsSelected.length) {
            return this.fButtonsSelected[n];
        }
        return false;
    }

    public void setSelection(int n, boolean bl) {
        if (n >= 0 && n < this.fButtonsSelected.length && this.fButtonsSelected[n] != bl) {
            Button button;
            this.fButtonsSelected[n] = bl;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[n]))) {
                button.setSelection(bl);
            }
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.fButtons != null) {
            boolean bl = this.isEnabled();
            int n = 0;
            while (n < this.fButtons.length) {
                Button button = this.fButtons[n];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(bl && this.fButtonsEnabled[n]);
                }
                ++n;
            }
        }
    }

    public void enableSelectionButton(int n, boolean bl) {
        if (n >= 0 && n < this.fButtonsEnabled.length) {
            Button button;
            this.fButtonsEnabled[n] = bl;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[n]))) {
                button.setEnabled(this.isEnabled() && bl);
            }
        }
    }

    static void access$000(ButtonGroupDialogField buttonGroupDialogField, SelectionEvent selectionEvent) {
        buttonGroupDialogField.doWidgetSelected(selectionEvent);
    }
}

