/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs;

import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.NewMethodWizardPage;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.NewMethodWizardStatus;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.ParameterInfo;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.DialogField;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.IDialogFieldsController;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.MethodDeclaringTypeField;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.MethodOtherModifiersField;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.MethodVisibilityModifiersField;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.fields.StringDialogField;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaElementLabelProvider;

public class NewMethodWizardPageController
implements IDialogFieldsController {
    private NewMethodWizardPage myWizardPage;
    private MethodDeclaringTypeField myMethodDeclaringTypeField;
    private StringDialogField myMethodNameField;
    private StringDialogField myMethodReturnTypeField;
    private MethodVisibilityModifiersField myMethodVisibilityModifiersField;
    private MethodOtherModifiersField myOtherModifiersField;
    private MethodParametersTable myMethodParametersTable;
    private IStatus myDeclaringTypeStatus = NewMethodWizardStatus.OK;
    private IStatus myMethodNameStatus = NewMethodWizardStatus.OK;
    private IStatus myMethodReturnTypeStatus = NewMethodWizardStatus.OK;
    private IStatus myMethodVisibilityModifiersStatus = NewMethodWizardStatus.OK;
    private IStatus myOtherModifiersStatus = NewMethodWizardStatus.OK;
    private IStatus myMethodParametersStatus = NewMethodWizardStatus.OK;
    private IStatus myNewMethodStatus = NewMethodWizardStatus.OK;

    public void setWizardPage(NewMethodWizardPage newMethodWizardPage) {
        this.myWizardPage = newMethodWizardPage;
    }

    public void setFocusDefault() {
        this.myMethodNameField.setFocus();
    }

    public void dialogFieldChanged(DialogField dialogField) {
        Object object = dialogField.getId();
        if (object == "FIELD_METHOD_DECLARING_TYPE") {
            this.doValidateDeclaringType();
        } else if (object == "FIELD_METHOD_UML_SIGNATURE") {
            this.doValidateMethodName();
        } else if (object == "FIELD_METHOD_RETURN_TYPE") {
            this.doValidateReturnTypeName();
        } else if (object == "FIELD_METHOD_VISIBILITY") {
            this.doValidateVisibility();
        } else if (object == "FIELD_METHOD_OTHER_MODIFIERS") {
            this.doValidateOtherModifiers();
        } else {
            return;
        }
        IStatus iStatus = this.getFieldsStatus();
        if (iStatus.isOK()) {
            this.doValidateNewMethod();
        }
        this.updateStatus();
    }

    public void methodParametersTableChanged() {
        this.doValidateParameters();
        IStatus iStatus = this.getFieldsStatus();
        if (iStatus.isOK()) {
            this.doValidateNewMethod();
        }
        this.updateStatus();
    }

    protected IStatus doValidateDeclaringType() {
        return NewMethodWizardStatus.OK;
    }

    protected IStatus doValidateMethodName() {
        String string = this.myMethodNameField.getText();
        IStatus iStatus = NewMethodWizardStatus.OK;
        if (string == null || string.length() == 0) {
            iStatus = new NewMethodWizardStatus(4, "method name is empty");
        } else {
            iStatus = JavaConventions.validateMethodName((String)string);
            if (iStatus.matches(4)) {
                iStatus = new NewMethodWizardStatus(4, "method name: " + iStatus.getMessage());
            }
        }
        this.myMethodNameStatus = iStatus;
        return this.myMethodNameStatus;
    }

    protected IStatus doValidateReturnTypeName() {
        String string = this.myMethodReturnTypeField.getText();
        IStatus iStatus = NewMethodWizardStatus.OK;
        if (string != null && string.length() != 0 && (iStatus = JavaElementUtil.validateJavaTypeName(string)).matches(4)) {
            iStatus = new NewMethodWizardStatus(4, "return type: " + iStatus.getMessage());
        }
        this.myMethodReturnTypeStatus = iStatus;
        return this.myMethodReturnTypeStatus;
    }

    protected IStatus doValidateVisibility() {
        return NewMethodWizardStatus.OK;
    }

    protected IStatus doValidateOtherModifiers() {
        return NewMethodWizardStatus.OK;
    }

    protected IStatus doValidateParameters() {
        IStatus iStatus = NewMethodWizardStatus.OK;
        ParameterInfo[] parameterInfoArray = this.myMethodParametersTable.getParameterInfos();
        int n = 0;
        while (n < parameterInfoArray.length) {
            ParameterInfo parameterInfo = parameterInfoArray[n];
            String string = "Parameter " + (n + 1) + " type: ";
            if (parameterInfo.typeName == null || parameterInfo.typeName.length() == 0) {
                iStatus = new NewMethodWizardStatus(4, string + "type is empty");
            } else {
                iStatus = JavaElementUtil.validateJavaTypeName(parameterInfo.typeName);
                if (iStatus.matches(4)) {
                    iStatus = new NewMethodWizardStatus(4, string + iStatus.getMessage());
                }
            }
            if (iStatus.isOK()) {
                string = "Parameter " + (n + 1) + " name: ";
                if (parameterInfo.name != null) {
                    iStatus = JavaConventions.validateIdentifier((String)parameterInfo.name);
                    if (iStatus.matches(4)) {
                        iStatus = new NewMethodWizardStatus(4, string + iStatus.getMessage());
                    } else if (!NewMethodWizardPageController.isUniqueParameterName(parameterInfo.name, parameterInfoArray, parameterInfo)) {
                        iStatus = new NewMethodWizardStatus(4, string + "duplicated");
                    }
                }
            }
            ++n;
        }
        this.myMethodParametersStatus = iStatus;
        return this.myMethodParametersStatus;
    }

    protected IStatus doValidateNewMethod() {
        this.myNewMethodStatus = NewMethodWizardStatus.OK;
        IType iType = this.getMethodDeclaringType();
        String string = this.getMethodName();
        ParameterInfo[] parameterInfoArray = this.getMethodParameterInfos();
        String[] stringArray = new String[parameterInfoArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = Signature.createTypeSignature((String)parameterInfoArray[n].typeName, (boolean)false);
            ++n;
        }
        try {
            IMethod iMethod = JavaElementUtil.findMethod(string, stringArray, false, iType);
            if (iMethod != null) {
                String string2 = new JavaElementLabelProvider().getText((Object)iMethod);
                String string3 = "Duplicate method " + string2 + " in type \n" + iType.getElementName();
                this.myNewMethodStatus = new NewMethodWizardStatus(4, string3);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return this.myNewMethodStatus;
    }

    public void doValidateAllAndUpdateStatus() {
        this.doValidateDeclaringType();
        this.doValidateMethodName();
        this.doValidateReturnTypeName();
        this.doValidateVisibility();
        this.doValidateOtherModifiers();
        this.doValidateParameters();
        IStatus iStatus = this.getFieldsStatus();
        if (iStatus.isOK()) {
            this.doValidateNewMethod();
        }
        this.updateStatus();
    }

    private IStatus getFieldsStatus() {
        IStatus iStatus = NewMethodWizardStatus.OK;
        if (!this.myDeclaringTypeStatus.isOK()) {
            iStatus = this.myDeclaringTypeStatus;
        } else if (!this.myMethodNameStatus.isOK()) {
            iStatus = this.myMethodNameStatus;
        } else if (!this.myMethodReturnTypeStatus.isOK()) {
            iStatus = this.myMethodReturnTypeStatus;
        } else if (!this.myMethodVisibilityModifiersStatus.isOK()) {
            iStatus = this.myMethodVisibilityModifiersStatus;
        } else if (!this.myOtherModifiersStatus.isOK()) {
            iStatus = this.myOtherModifiersStatus;
        } else if (!this.myMethodParametersStatus.isOK()) {
            iStatus = this.myMethodParametersStatus;
        }
        return iStatus;
    }

    public void updateStatus() {
        IStatus iStatus = this.getFieldsStatus();
        if (iStatus.isOK()) {
            iStatus = this.myNewMethodStatus;
        }
        this.myWizardPage.updateStatus(iStatus);
    }

    public void setMethodDeclaringTypeField(MethodDeclaringTypeField methodDeclaringTypeField) {
        this.myMethodDeclaringTypeField = methodDeclaringTypeField;
        this.myMethodDeclaringTypeField.setDialogFieldsController(this);
    }

    public void setMethodNameField(StringDialogField stringDialogField) {
        this.myMethodNameField = stringDialogField;
        this.myMethodNameField.setDialogFieldsController(this);
    }

    public void setMethodReturnTypeField(StringDialogField stringDialogField) {
        this.myMethodReturnTypeField = stringDialogField;
        this.myMethodReturnTypeField.setDialogFieldsController(this);
    }

    public void setVisibilityModifierField(MethodVisibilityModifiersField methodVisibilityModifiersField) {
        this.myMethodVisibilityModifiersField = methodVisibilityModifiersField;
        this.myMethodVisibilityModifiersField.setDialogFieldsController(this);
    }

    public void setOtherModifierField(MethodOtherModifiersField methodOtherModifiersField) {
        this.myOtherModifiersField = methodOtherModifiersField;
        this.myOtherModifiersField.setDialogFieldsController(this);
    }

    public void setMethodParametersTable(MethodParametersTable methodParametersTable) {
        this.myMethodParametersTable = methodParametersTable;
    }

    public IType getMethodDeclaringType() {
        return this.myMethodDeclaringTypeField.getCurrentType();
    }

    public String getMethodName() {
        return this.myMethodNameField.getText();
    }

    public String getMethodReturnTypeName() {
        return this.myMethodReturnTypeField.getText();
    }

    public ParameterInfo[] getMethodParameterInfos() {
        ParameterInfo[] parameterInfoArray = this.myMethodParametersTable.getParameterInfos();
        ParameterInfo[] parameterInfoArray2 = new ParameterInfo[parameterInfoArray.length];
        System.arraycopy(parameterInfoArray, 0, parameterInfoArray2, 0, parameterInfoArray.length);
        int n = 0;
        while (n < parameterInfoArray2.length) {
            String string = parameterInfoArray2[n].name;
            if (string == null || string.length() == 0) {
                string = "parm0";
                if (!NewMethodWizardPageController.isUniqueParameterName(string, parameterInfoArray2, null)) {
                    string = NewMethodWizardPageController.makeUniqueParameterName("parm", parameterInfoArray2);
                }
                parameterInfoArray2[n].name = string;
            }
            ++n;
        }
        return parameterInfoArray2;
    }

    public boolean isMethodPublic() {
        return this.myMethodVisibilityModifiersField.isSelected(0);
    }

    public boolean isMethodPrivate() {
        return this.myMethodVisibilityModifiersField.isSelected(2);
    }

    public boolean isMethodProtected() {
        return this.myMethodVisibilityModifiersField.isSelected(3);
    }

    public boolean isMethodPackageLocal() {
        return this.myMethodVisibilityModifiersField.isSelected(1);
    }

    public boolean isMethodAbstract() {
        return this.myOtherModifiersField.isSelected(0);
    }

    public boolean isMethodFinal() {
        return this.myOtherModifiersField.isSelected(1);
    }

    public boolean isMethodStatic() {
        return this.myOtherModifiersField.isSelected(2);
    }

    public static boolean isUniqueParameterName(String string, ParameterInfo[] parameterInfoArray, ParameterInfo parameterInfo) {
        if (string == null) {
            return true;
        }
        int n = 0;
        while (n < parameterInfoArray.length) {
            if (parameterInfoArray[n] != parameterInfo && string.equals(parameterInfoArray[n].name)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String makeUniqueParameterName(String string, ParameterInfo[] parameterInfoArray) {
        String string2 = null;
        int n = 0;
        while (!NewMethodWizardPageController.isUniqueParameterName(string2 = string + n++, parameterInfoArray, null)) {
        }
        return string2;
    }
}

