/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs;

import com.togethersoft.togetherxj.uml.cdl.core.ISearchSupport;
import com.togethersoft.togetherxj.uml.cdl.core.NullSearchSupport;
import com.togethersoft.togetherxj.uml.cdl.ui.CdlMessages;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$1;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$2;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$3;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$4;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$5;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$AutoApplyTextCellEditor;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$ParameterInfoContentProvider;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$ParameterInfoLabelProvider;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$ParametersCellModifier;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.MethodParametersTable$TypeComboDialogCellEditor;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.NewMethodWizardPageController;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.ParameterInfo;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.SWTUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MethodParametersTable {
    private static final int TYPE_PROP = 0;
    private static final int NAME_PROP = 1;
    private static final String[] PROPERTIES = new String[]{"type", "name"};
    private static final int ROW_COUNT = 4;
    private TableViewer myTableViewer;
    private Button myUpButton;
    private Button myDownButton;
    private Button myAddButton;
    private Button myRemoveButton;
    private FontMetrics myFontMetrics;
    private List myParametersList;
    private CellEditor[] myEditors = new CellEditor[PROPERTIES.length];
    private NewMethodWizardPageController myPageController;
    private IRunnableContext myRunnableContext;
    private ISearchSupport mySearchSupport;
    public static final String[] types = new String[]{"String", "boolean", "byte", "char", "double", "float", "int", "long", "short"};

    public MethodParametersTable(NewMethodWizardPageController newMethodWizardPageController, ParameterInfo[] parameterInfoArray) {
        this.myPageController = newMethodWizardPageController;
        this.mySearchSupport = new NullSearchSupport();
        this.myParametersList = parameterInfoArray != null ? new ArrayList<ParameterInfo>(Arrays.asList(parameterInfoArray)) : new ArrayList();
    }

    public void setRunnableContext(IRunnableContext iRunnableContext) {
        this.myRunnableContext = iRunnableContext;
    }

    public void setSearchSupport(ISearchSupport iSearchSupport) {
        this.mySearchSupport = iSearchSupport;
    }

    protected IRunnableContext getRunnableContext() {
        return this.myRunnableContext;
    }

    public void createTableComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(CdlMessages.getString("MethodParametersTable.&Parameters_3"));
        this.createParameterList(composite2);
        this.createButtonComposite(composite2);
    }

    protected void createParameterList(Composite composite) {
        Composite composite2 = composite;
        this.myTableViewer = new TableViewer(composite2, 101122);
        this.myTableViewer.setUseHashlookup(true);
        Table table = this.myTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableLayout(table);
        this.addCellEditors();
        this.myTableViewer.setContentProvider((IContentProvider)new MethodParametersTable$ParameterInfoContentProvider(null));
        this.myTableViewer.setLabelProvider((IBaseLabelProvider)new MethodParametersTable$ParameterInfoLabelProvider(null));
        this.updateTableInput();
        this.myTableViewer.addSelectionChangedListener((ISelectionChangedListener)new MethodParametersTable$1(this));
        this.myTableViewer.getTable().addMouseListener((MouseListener)new MethodParametersTable$2(this));
    }

    private TableLayout createTableLayout(Table table) {
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(300), new ColumnPixelData(200)};
        tableLayout.addColumnData(columnLayoutDataArray[0]);
        tableLayout.addColumnData(columnLayoutDataArray[1]);
        TableColumn tableColumn = new TableColumn(table, 0, 0);
        tableColumn.setResizable(true);
        tableColumn.setText(CdlMessages.getString("MethodParametersTable.type_4"));
        tableColumn = new TableColumn(table, 0, 1);
        tableColumn.setResizable(true);
        tableColumn.setText(CdlMessages.getString("MethodParametersTable.name_5"));
        return tableLayout;
    }

    private void updateTableInput() {
        ParameterInfo[] parameterInfoArray = new ParameterInfo[this.myParametersList.size()];
        this.myParametersList.toArray(parameterInfoArray);
        this.myTableViewer.setInput((Object)parameterInfoArray);
    }

    protected void createButtonComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.myAddButton = this.createAddButton(composite2, CdlMessages.getString("MethodParametersTable.&Add_6"));
        this.myRemoveButton = this.createRemoveButton(composite2, CdlMessages.getString("MethodParametersTable.Rem&ove_7"));
        this.myUpButton = this.createMoveButton(composite2, CdlMessages.getString("MethodParametersTable.Move_&Up_8"), true);
        this.myDownButton = this.createMoveButton(composite2, CdlMessages.getString("MethodParametersTable.Mov&e_Down_9"), false);
        this.updateButtonsEnabledState();
    }

    private void updateButtonsEnabledState() {
        this.myDownButton.setEnabled(this.canMoveDown());
        this.myUpButton.setEnabled(this.canMoveUp());
        int[] nArray = this.myTableViewer.getTable().getSelectionIndices();
        this.myRemoveButton.setEnabled(nArray.length > 0);
    }

    private void tableModified() {
        this.myPageController.methodParametersTableChanged();
    }

    public ParameterInfo[] getParameterInfos() {
        return (ParameterInfo[])this.myTableViewer.getInput();
    }

    private Button createMoveButton(Composite composite, String string, boolean bl) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.setLayoutData((Object)new GridData(768));
        this.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new MethodParametersTable$3(this, bl));
        return button;
    }

    private Button createAddButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setEnabled(true);
        button.setText(string);
        button.setLayoutData((Object)new GridData(768));
        this.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new MethodParametersTable$4(this));
        return button;
    }

    private Button createRemoveButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.setLayoutData((Object)new GridData(768));
        this.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new MethodParametersTable$5(this));
        return button;
    }

    private ParameterInfo[] getSelectedItems() {
        ISelection iSelection = this.myTableViewer.getSelection();
        if (iSelection == null) {
            return new ParameterInfo[0];
        }
        if (!(iSelection instanceof IStructuredSelection)) {
            return new ParameterInfo[0];
        }
        List list = ((IStructuredSelection)iSelection).toList();
        return list.toArray(new ParameterInfo[list.size()]);
    }

    private void moveUp() {
        int[] nArray = this.myTableViewer.getTable().getSelectionIndices();
        ArrayList arrayList = new ArrayList(nArray.length);
        int n = nArray[0];
        int n2 = 0;
        while (n2 < nArray.length) {
            arrayList.add(this.myParametersList.get(n));
            this.myParametersList.remove(n);
            ++n2;
        }
        this.myParametersList.addAll(n - 1, arrayList);
        this.updateTableInput();
    }

    private void moveDown() {
        int[] nArray = this.myTableViewer.getTable().getSelectionIndices();
        ArrayList arrayList = new ArrayList(nArray.length);
        int n = nArray[0];
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            arrayList.add(this.myParametersList.get(n));
            this.myParametersList.remove(n);
            --n2;
        }
        this.myParametersList.addAll(n + 1, arrayList);
        this.updateTableInput();
    }

    private boolean canMoveUp() {
        int[] nArray = this.myTableViewer.getTable().getSelectionIndices();
        if (nArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < nArray.length - 1) {
            if (nArray[n] + 1 != nArray[n + 1]) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != n2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean canMoveDown() {
        int[] nArray = this.myTableViewer.getTable().getSelectionIndices();
        if (nArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < nArray.length - 1) {
            if (nArray[n] + 1 != nArray[n + 1]) {
                return false;
            }
            ++n;
        }
        int n2 = nArray.length - 1;
        int n3 = this.getParameterInfos().length - 1;
        while (n2 >= 0) {
            if (nArray[n2] != n3) {
                return true;
            }
            --n2;
            --n3;
        }
        return false;
    }

    private ParameterInfo addParameter() {
        ParameterInfo parameterInfo = new ParameterInfo("Object", "arg" + this.myParametersList.size());
        this.myParametersList.add(parameterInfo);
        this.updateTableInput();
        return parameterInfo;
    }

    private ParameterInfo removeParameter() {
        int[] nArray = this.myTableViewer.getTable().getSelectionIndices();
        ArrayList arrayList = new ArrayList(nArray.length);
        int n = nArray[0];
        int n2 = 0;
        while (n2 < nArray.length) {
            arrayList.add(this.myParametersList.get(n));
            this.myParametersList.remove(n);
            ++n2;
        }
        ParameterInfo parameterInfo = null;
        if (n < this.myParametersList.size()) {
            parameterInfo = (ParameterInfo)this.myParametersList.get(n);
        } else if (this.myParametersList.size() > 0) {
            parameterInfo = (ParameterInfo)this.myParametersList.get(this.myParametersList.size() - 1);
        }
        this.updateTableInput();
        return parameterInfo;
    }

    private void setButtonDimensionHint(Button button) {
        if (this.myFontMetrics == null) {
            this.myFontMetrics = SWTUtil.getFontMetrics((Control)button);
        }
        SWTUtil.setButtonDimensionHint(button, this.myFontMetrics);
    }

    private void addCellEditors() {
        this.myEditors[0] = this.createTypeCellEditor();
        this.myEditors[1] = this.createNameCellEditor();
        this.myTableViewer.setCellEditors(this.myEditors);
        this.myTableViewer.setColumnProperties(PROPERTIES);
        this.myTableViewer.setCellModifier((ICellModifier)new MethodParametersTable$ParametersCellModifier(this, null));
    }

    private CellEditor createTypeCellEditor() {
        return new MethodParametersTable$TypeComboDialogCellEditor(this, (Composite)this.myTableViewer.getTable());
    }

    private CellEditor createNameCellEditor() {
        MethodParametersTable$AutoApplyTextCellEditor methodParametersTable$AutoApplyTextCellEditor = new MethodParametersTable$AutoApplyTextCellEditor(this, (Composite)this.myTableViewer.getTable());
        return methodParametersTable$AutoApplyTextCellEditor;
    }

    private void activateCellEditorAt(Point point) {
        TableItem tableItem = this.myTableViewer.getTable().getItem(point);
        if (tableItem == null || tableItem.isDisposed()) {
            return;
        }
        int n = -1;
        int n2 = this.myTableViewer.getTable().getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            Rectangle rectangle = tableItem.getBounds(n3);
            if (rectangle.contains(point)) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n == -1) {
            return;
        }
        this.myTableViewer.editElement(tableItem.getData(), n);
    }

    static void access$200(MethodParametersTable methodParametersTable) {
        methodParametersTable.updateButtonsEnabledState();
    }

    static void access$300(MethodParametersTable methodParametersTable, Point point) {
        methodParametersTable.activateCellEditorAt(point);
    }

    static TableViewer access$400(MethodParametersTable methodParametersTable) {
        return methodParametersTable.myTableViewer;
    }

    static ParameterInfo[] access$500(MethodParametersTable methodParametersTable) {
        return methodParametersTable.getSelectedItems();
    }

    static void access$600(MethodParametersTable methodParametersTable) {
        methodParametersTable.moveUp();
    }

    static void access$700(MethodParametersTable methodParametersTable) {
        methodParametersTable.moveDown();
    }

    static void access$800(MethodParametersTable methodParametersTable) {
        methodParametersTable.tableModified();
    }

    static ParameterInfo access$900(MethodParametersTable methodParametersTable) {
        return methodParametersTable.addParameter();
    }

    static ParameterInfo access$1000(MethodParametersTable methodParametersTable) {
        return methodParametersTable.removeParameter();
    }

    static String[] access$1200() {
        return PROPERTIES;
    }

    static ISearchSupport access$1500(MethodParametersTable methodParametersTable) {
        return methodParametersTable.mySearchSupport;
    }
}

