/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs;

import com.togethersoft.togetherxj.uml.cdl.ui.CdlMessages;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.AbstractOperationSelectorData;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.AbstractOperationSelectorData$DefaultSorter;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.OperationsTreeContentProvider;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class MessageOperationSelectorData
extends AbstractOperationSelectorData {
    private IType mySenderType;
    private IType myReceiverType;
    private ITypeHierarchy myHierarchy;
    private Object[] myTypes;
    private IMethod[] myMethods;
    private IMethod[] myInitiallySelectedMethods;
    private Object[] myInitiallyExpandedTypes;
    private boolean mySuperOverriddenMethodOnly;

    public MessageOperationSelectorData(IType iType, IType iType2) {
        this.mySenderType = iType;
        this.myReceiverType = iType2;
    }

    public String getTitle() {
        return CdlMessages.getString("SelectMethodDialog.title");
    }

    public String getMessage() {
        return CdlMessages.getFormattedString("SelectMethodDialog.form_hierarchy_message", this.myReceiverType.getElementName());
    }

    protected void initialize() throws JavaModelException {
        this.myHierarchy = this.myReceiverType.newSupertypeHierarchy(null);
        this.setTypeHierarchy(this.myHierarchy);
        List list = this.createMethodsList();
        this.myMethods = list.toArray(new IMethod[list.size()]);
        this.myTypes = this.createTypesArray(this.myMethods, this.myHierarchy);
    }

    protected List createMethodsList() {
        List list = null;
        list = this.mySuperOverriddenMethodOnly ? JavaElementUtil.createSuperOverriddenMethodsList(this.myReceiverType, this.myHierarchy) : JavaElementUtil.createAllMethodsList(this.myReceiverType, this.myHierarchy);
        return list;
    }

    public void setSuperOverriddenMethodsOnly(boolean bl) {
        this.mySuperOverriddenMethodOnly = bl;
    }

    public void setInitiallySelectedMethod(IMethod iMethod) {
        this.myInitiallySelectedMethods = new IMethod[]{iMethod};
        this.myInitiallyExpandedTypes = new Object[]{iMethod.getDeclaringType()};
    }

    public Object[] getInitiallySelectedElements() {
        return this.myInitiallySelectedMethods;
    }

    public Object[] getExpandedElements() {
        return this.myInitiallyExpandedTypes;
    }

    public ITreeContentProvider createTreeContentProvider() {
        if (this.myMethods == null) {
            try {
                this.initialize();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return new OperationsTreeContentProvider(this.myMethods, this.myTypes);
    }

    protected Object[] createTypesArray(IMethod[] iMethodArray, ITypeHierarchy iTypeHierarchy) {
        HashSet<IType> hashSet = new HashSet<IType>(iMethodArray.length);
        int n = 0;
        while (n < iMethodArray.length) {
            hashSet.add(iMethodArray[n].getDeclaringType());
            ++n;
        }
        Object[] objectArray = ((AbstractCollection)hashSet).toArray();
        AbstractOperationSelectorData$DefaultSorter abstractOperationSelectorData$DefaultSorter = new AbstractOperationSelectorData$DefaultSorter(iTypeHierarchy);
        abstractOperationSelectorData$DefaultSorter.sort(null, objectArray);
        return objectArray;
    }
}

