/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.dialogs;

import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.AbstractTreeSelectionDialog$1;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.AbstractTreeSelectionDialog$2;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.SelectionStatus$ERROR;
import com.togethersoft.togetherxj.uml.cdl.ui.dialogs.SelectionStatus$OK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AbstractTreeSelectionDialog
extends SelectionDialog {
    private static final Object[] ZERO_OBJECTS_ARRAY = new Object[0];
    private TreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ViewerSorter fSorter;
    private List fFilters;
    private Object fInput;
    private ISelectionStatusValidator fValidator;
    private Object[] fExpandedElements;
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean fIsEmpty;
    private IStatus fCurrStatus = new SelectionStatus$OK();

    public AbstractTreeSelectionDialog(Shell shell) {
        super(shell);
        this.setResult(new ArrayList(0));
        this.fExpandedElements = null;
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
        this.setInput((Object)this);
    }

    public void setTreeContentProvider(ITreeContentProvider iTreeContentProvider) {
        this.fContentProvider = iTreeContentProvider;
    }

    protected ITreeContentProvider getTreeContentProvider() {
        return this.fContentProvider;
    }

    public void setLabelProvider(ILabelProvider iLabelProvider) {
        this.fLabelProvider = iLabelProvider;
    }

    public void setSorter(ViewerSorter viewerSorter) {
        this.fSorter = viewerSorter;
    }

    public void addFilter(ViewerFilter viewerFilter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(viewerFilter);
    }

    public void setValidator(ISelectionStatusValidator iSelectionStatusValidator) {
        this.fValidator = iSelectionStatusValidator;
    }

    public void setInput(Object object) {
        this.fInput = object;
    }

    public void setExpandedElements(Object[] objectArray) {
        this.fExpandedElements = objectArray;
    }

    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    protected void updateStatusAndResult() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.getSelection());
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new SelectionStatus$OK();
            }
        } else {
            this.fCurrStatus = new SelectionStatus$ERROR();
        }
        if (this.fCurrStatus.isOK()) {
            this.computeResult();
        } else {
            this.setResult(null);
        }
    }

    protected Object[] getSelection() {
        StructuredSelection structuredSelection = (StructuredSelection)this.fViewer.getSelection();
        return structuredSelection.toArray();
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        BusyIndicator.showWhile(null, (Runnable)new AbstractTreeSelectionDialog$1(this));
        return this.getReturnCode();
    }

    private void access$superOpen() {
        super.open();
    }

    public Object[] getResult() {
        Object[] objectArray = super.getResult();
        if (objectArray == null) {
            return ZERO_OBJECTS_ARRAY;
        }
        return objectArray;
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        List<Object> list = Arrays.asList(this.getSelection());
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
        }
        this.setResult(list);
    }

    public void create() {
        super.create();
        List list = this.getInitialSelections();
        if (list != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(list), true);
        }
        if (this.fExpandedElements != null) {
            this.fViewer.setExpandedElements(this.fExpandedElements);
        }
        this.updateStatusAndResult();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = this.createMessageArea(composite2);
        Tree tree = this.createTreeViewer(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        tree.setLayoutData((Object)gridData);
        if (this.fIsEmpty) {
            label.setEnabled(false);
            tree.setEnabled(false);
        }
        return composite2;
    }

    protected Tree createTreeViewer(Composite composite) {
        this.fViewer = new TreeViewer(composite, 2048);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)new AbstractTreeSelectionDialog$2(this));
        this.fViewer.setSorter(this.fSorter);
        if (this.fFilters != null) {
            int n = 0;
            while (n != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(n));
                ++n;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer.getTree();
    }

    private boolean evaluateIfTreeEmpty(Object object) {
        Object[] objectArray = this.fContentProvider.getElements(object);
        if (objectArray.length > 0 && this.fFilters != null) {
            int n = 0;
            while (n < this.fFilters.size()) {
                ViewerFilter viewerFilter = (ViewerFilter)this.fFilters.get(n);
                objectArray = viewerFilter.filter((Viewer)this.fViewer, object, objectArray);
                ++n;
            }
        }
        return objectArray.length == 0;
    }

    static void access$000(AbstractTreeSelectionDialog abstractTreeSelectionDialog) {
        abstractTreeSelectionDialog.access$superOpen();
    }
}

