/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.actions;

import com.togethersoft.togetherxj.uml.cdl.core.MessageOperation;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationConnector;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationHelper;
import com.togethersoft.togetherxj.uml.cdl.ui.CdlMessages;
import com.togethersoft.togetherxj.uml.cdl.ui.actions.MessageOperationListMenu$1;
import com.togethersoft.togetherxj.uml.cdl.ui.actions.MessageOperationListMenu$3;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MessageOperationListMenu
extends ContributionItem {
    private Entity myEntity;
    private Reference myReference;
    private boolean mySuperMethodOnly;
    private static final int MAX_METHODS_IN_MENU = 20;

    public MessageOperationListMenu(Reference reference) {
        this.myReference = reference;
        this.myEntity = reference.getEntity();
    }

    public MessageOperationListMenu(Entity entity) {
        this.myEntity = entity;
    }

    public void setSuperMethodsOnly(boolean bl) {
        this.mySuperMethodOnly = bl;
    }

    public void fill(Menu menu, int n) {
        MenuItem menuItem;
        List list;
        IType iType;
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        Entity entity = MessageOperationHelper.getTargetClass(this.myEntity);
        if (entity != null && (iType = JavaElementUtil.model2javaType((Element)entity)) != null) {
            list = Collections.EMPTY_LIST;
            MessageOperationConnector messageOperationConnector = new MessageOperationConnector(this.myEntity);
            if (!messageOperationConnector.isEmpty() && messageOperationConnector.isPureText()) {
                list = this.getAllSimilarMethods(iType, this.mySuperMethodOnly, messageOperationConnector.getMessageOperation());
                arrayList.addAll(list);
            }
            int n2 = 20 - arrayList.size();
            menuItem = this.getTopMethods(iType, this.mySuperMethodOnly);
            int n3 = 0;
            while (n3 < ((IMethod[])menuItem).length && n3 < n2) {
                try {
                    if (JavaElementUtil.findMethod((IMethod)menuItem[n3], list) == null) {
                        arrayList.add(menuItem[n3]);
                    } else {
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++n3;
            }
        }
        if (arrayList.size() == 0) {
            iType = new MenuItem(menu, 8, n++);
            iType.setText(CdlMessages.getString("MessageOperationListMenu.Empty"));
            iType.setEnabled(false);
            return;
        }
        int n4 = JavaElementLabelProvider.SHOW_DEFAULT | 1;
        if (this.mySuperMethodOnly) {
            // empty if block
        }
        list = new JavaElementLabelProvider(n4);
        int n5 = 0;
        while (n5 < arrayList.size()) {
            IMethod iMethod = (IMethod)arrayList.get(n5);
            menuItem = new MenuItem(menu, 8, n++);
            menuItem.setText(list.getText(iMethod));
            menuItem.setImage(list.getImage(iMethod));
            menuItem.addSelectionListener((SelectionListener)new MessageOperationListMenu$1(this, iMethod));
            ++n5;
        }
    }

    private IMethod[] getTopMethods(IType iType, boolean bl) {
        IMethod[] iMethodArray = new IMethod[]{};
        try {
            if (!bl) {
                iMethodArray = iType.getMethods();
            } else {
                IMethod[] iMethodArray2;
                IType iType2;
                ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
                IType[] iTypeArray = iTypeHierarchy.getSupertypes(iType);
                ArrayList<IMethod> arrayList = new ArrayList<IMethod>();
                int n = 0;
                while (n < iTypeArray.length) {
                    iType2 = iTypeArray[n];
                    iMethodArray2 = iType2.getMethods();
                    if (iMethodArray2.length > 0) {
                        arrayList.addAll(Arrays.asList(iMethodArray2));
                    }
                    ++n;
                }
                iType2 = new ArrayList();
                iMethodArray2 = arrayList.iterator();
                while (iMethodArray2.hasNext()) {
                    IMethod iMethod = (IMethod)iMethodArray2.next();
                    if (!JavaElementUtil.isOverriddenMethod(iType, iMethod)) continue;
                    iType2.add(iMethod);
                }
                if (iType2.size() > 0) {
                    iMethodArray = iType2.toArray(new IMethod[iType2.size()]);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        Arrays.sort(iMethodArray, new MessageOperationListMenu$3(this));
        return iMethodArray;
    }

    private List getAllSimilarMethods(IType iType, boolean bl, MessageOperation messageOperation) {
        try {
            List list = null;
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
            list = !bl ? JavaElementUtil.createAllMethodsList(iType, iTypeHierarchy) : JavaElementUtil.createSuperOverriddenMethodsList(iType, iTypeHierarchy);
            list = JavaElementUtil.createSimilarMethodsList(list, messageOperation.getMethodName(), messageOperation.getParametersTypes(), messageOperation.isConstructor());
            return list;
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isEmpty() {
        return false;
    }

    static Entity access$100(MessageOperationListMenu messageOperationListMenu) {
        return messageOperationListMenu.myEntity;
    }

    static Reference access$300(MessageOperationListMenu messageOperationListMenu) {
        return messageOperationListMenu.myReference;
    }
}

