/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui.actions;

import com.togethersoft.togetherxj.uml.cdl.ui.CdlMessages;
import com.togethersoft.togetherxj.uml.cdl.ui.CdlUI;
import com.togethersoft.togetherxj.uml.cdl.ui.actions.AbstractSelectionAwareActionEx;
import com.togethersoft.togetherxj.uml.cdl.util.Assert;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.IElementWrapper;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class AbstractNavigateAction
extends AbstractSelectionAwareActionEx {
    public static final String RESOURCE_NAVIGATOR_VIEW = "org.eclipse.ui.views.ResourceNavigator";
    public static final String PACKAGE_EXPLORER_VIEW = "org.eclipse.jdt.ui.PackageExplorer";
    public static final String MODEL_NAVIGATOR_VIEW = "com.tssap.selena.model.ui.navigator.view";
    private IWorkbenchPart myWorkbenchPart;

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean isMultiselection() {
        return this.getSelection().size() > 1;
    }

    protected void showInEditor(Element element) {
        ModelUIPlugin.getDefault().openEditor(element, this.getSite().getPage(), true);
    }

    protected void showInEditor(IJavaElement iJavaElement) {
        Element element = JavaElementUtil.java2model(iJavaElement);
        Assert.assertNotNull("Couldn't find model element for java element:\n" + iJavaElement.getElementName(), element);
        ModelUIPlugin.getDefault().openEditor(element, this.getSite().getPage(), true);
    }

    protected void showInNavigator(Element element) {
        IJavaElement iJavaElement = JavaElementUtil.model2java(element);
        Assert.assertNotNull("Couldn't find java element for model element:\n" + element.getPropertyValue("$fullName"), iJavaElement);
        this.showInNavigator(iJavaElement);
    }

    protected void showInNavigator(IJavaElement iJavaElement) {
        try {
            IResource iResource = this.getResource(iJavaElement);
            this.showInNavigator(iResource);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    protected void showInNavigator(IResource iResource) {
        if (iResource != null) {
            try {
                IViewPart iViewPart = this.showView(RESOURCE_NAVIGATOR_VIEW);
                if (this.reveal(iViewPart, iResource)) {
                    return;
                }
                CdlUI.showErrorDialog(CdlMessages.getString("AbstractNavigateAction.UnableToFindElement") + iResource.getLocation() + CdlMessages.getString("AbstractNavigateAction.in") + RESOURCE_NAVIGATOR_VIEW);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
    }

    protected void showInPackageExplorer(Element element) {
        IJavaElement iJavaElement = JavaElementUtil.model2java(element);
        Assert.assertNotNull("Couldn't find java element for model element:\n" + element.getPropertyValue("$fullName"), iJavaElement);
        this.showInPackageExplorer(iJavaElement);
    }

    protected void showInPackageExplorer(IJavaElement iJavaElement) {
        if (iJavaElement != null) {
            try {
                IPackagesViewPart iPackagesViewPart = (IPackagesViewPart)this.showView(PACKAGE_EXPLORER_VIEW);
                if (this.reveal((IViewPart)iPackagesViewPart, iJavaElement)) {
                    return;
                }
                if (!this.revealInPackageExplorer(iPackagesViewPart, iJavaElement)) {
                    CdlUI.showErrorDialog(CdlMessages.getString("AbstractNavigateAction.UnableToFindElement") + iJavaElement.getElementName() + CdlMessages.getString("AbstractNavigateAction.in") + PACKAGE_EXPLORER_VIEW);
                }
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
    }

    protected void showInModelNavigator(IJavaElement iJavaElement) {
        Element element = JavaElementUtil.java2model(iJavaElement);
        Assert.assertNotNull("Couldn't find model element for java element:\n" + iJavaElement.getElementName(), element);
        this.showInModelNavigator(element);
    }

    protected void showInModelNavigator(Element element) {
        if (element != null) {
            try {
                IViewPart iViewPart = this.showView(MODEL_NAVIGATOR_VIEW);
                if (this.reveal(iViewPart, element)) {
                    return;
                }
                CdlUI.showErrorDialog(CdlMessages.getString("AbstractNavigateAction.UnableToFindElement") + element.getPropertyValue("$fullName") + CdlMessages.getString("AbstractNavigateAction.in") + MODEL_NAVIGATOR_VIEW);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
    }

    private IViewPart showView(String string) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = this.getSite().getWorkbenchWindow().getActivePage();
        IViewPart iViewPart = iWorkbenchPage.showView(string);
        return iViewPart;
    }

    private boolean reveal(IViewPart iViewPart, Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        if (iViewPart instanceof ISetSelectionTarget) {
            ((ISetSelectionTarget)iViewPart).selectReveal((ISelection)new StructuredSelection(object));
        }
        if ((object2 = this.getSelectedElement(iViewPart)) instanceof IElementWrapper) {
            IElementWrapper iElementWrapper = (IElementWrapper)object2;
            object2 = iElementWrapper.getOriginalElement();
        }
        if (object instanceof IResource && object2 instanceof IJavaElement) {
            try {
                return object.equals(((IJavaElement)object2).getCorrespondingResource());
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
        }
        return object.equals(object2);
    }

    private Object getSelectedElement(IViewPart iViewPart) {
        return ((IStructuredSelection)iViewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private boolean revealInPackageExplorer(IPackagesViewPart iPackagesViewPart, Object object) {
        IJavaElement iJavaElement;
        if (!(object instanceof IJavaElement)) {
            return false;
        }
        IJavaElement iJavaElement2 = (IJavaElement)object;
        if (!JavaElementUtil.isWorkingCopy(iJavaElement2) && (iJavaElement = JavaElementUtil.getWorkingCopy(iJavaElement2)) != null && this.reveal((IViewPart)iPackagesViewPart, iJavaElement)) {
            return true;
        }
        iJavaElement = (IJavaElement)iJavaElement2.getOpenable();
        if (iJavaElement == null) {
            return false;
        }
        if (this.reveal((IViewPart)iPackagesViewPart, iJavaElement)) {
            return true;
        }
        IResource iResource = null;
        try {
            iResource = iJavaElement.getCorrespondingResource();
            return this.reveal((IViewPart)iPackagesViewPart, iResource);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
            return false;
        }
    }

    private IResource getResource(IJavaElement object) throws JavaModelException {
        IOpenable iOpenable;
        if (object == null) {
            return null;
        }
        if (object instanceof IMember) {
            iOpenable = object.getOpenable();
            object = iOpenable instanceof IJavaElement ? (IJavaElement)iOpenable : null;
        }
        if (object instanceof ICompilationUnit && (iOpenable = (ICompilationUnit)object).isWorkingCopy()) {
            object = iOpenable.getOriginalElement();
        }
        if (object == null) {
            return null;
        }
        iOpenable = object.getCorrespondingResource();
        if (iOpenable == null) {
            iOpenable = object.getUnderlyingResource();
        }
        return iOpenable;
    }
}

