/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.ui;

import com.togethersoft.togetherxj.uml.cdl.CdlPlugin;
import com.togethersoft.togetherxj.uml.cdl.core.GenericSearchSupport;
import com.togethersoft.togetherxj.uml.cdl.core.ISearchSupport;
import com.togethersoft.togetherxj.uml.cdl.core.ObjectClassHelper;
import com.togethersoft.togetherxj.uml.cdl.ui.CdlMessages;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.properties.internal.TypeSelectionDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CdlUI {
    private static TypeSelectionDialog ourTypeDialog;

    public static Shell getShell() {
        return CdlUI.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return CdlUI.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CdlUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static IDialogSettings getDialogSettings() {
        return CdlPlugin.getDefault().getDialogSettings();
    }

    public static Image getImage(String string) {
        return CdlPlugin.getDefault().getImageRegistry().get(string);
    }

    public static void showInformationDialog(String string) {
        MessageDialog.openInformation((Shell)CdlUI.getShell(), (String)CdlMessages.getString("CdlUI.Information_1"), (String)string);
    }

    public static void showErrorDialog(String string) {
        MessageDialog.openError((Shell)CdlUI.getShell(), (String)CdlMessages.getString("CdlUI.Error_2"), (String)string);
    }

    public static int convertWidthInCharsToPixels(FontMetrics fontMetrics, int n) {
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)n);
    }

    public static int convertHeightInCharsToPixels(FontMetrics fontMetrics, int n) {
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)n);
    }

    public static FontMetrics getFontMetrics() {
        return CdlUI.getFontMetrics((Control)CdlUI.getShell());
    }

    public static FontMetrics getFontMetrics(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return fontMetrics;
    }

    public static TypeSelectionDialog getTypeDialog() {
        if (ourTypeDialog == null) {
            ourTypeDialog = CdlUI.createTypeDialog();
        }
        ourTypeDialog.setTitle(CdlMessages.getString("SelectTypeDialog.title"));
        ourTypeDialog.setMessage(CdlMessages.getString("SelectTypeDialog.default_message"));
        return ourTypeDialog;
    }

    private static TypeSelectionDialog createTypeDialog() {
        String string = "com.tssap.selena.properties.typeSelectionDialog";
        String string2 = "order";
        String string3 = "class";
        IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor(string);
        IConfigurationElement iConfigurationElement = null;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            try {
                int n3 = Integer.parseInt(iConfigurationElementArray[n2].getAttribute(string2));
                if (n3 < n) {
                    n = n3;
                    iConfigurationElement = iConfigurationElementArray[n2];
                }
            }
            catch (NumberFormatException numberFormatException) {
                CdlPlugin.getDefault().log(2, CdlMessages.getString("SelectTypeDialog.config.TypeDialogMalformedOrderAttribute"), numberFormatException);
            }
            ++n2;
        }
        if (iConfigurationElement == null) {
            throw new IllegalStateException(CdlMessages.getString("SelectTypeDialog.config.NoTypeDialog"));
        }
        try {
            return (TypeSelectionDialog)iConfigurationElement.createExecutableExtension(string3);
        }
        catch (CoreException coreException) {
            CdlPlugin.getDefault().getLog().log(coreException.getStatus());
            throw new IllegalStateException(CdlMessages.getString("SelectTypeDialog.config.CantInstTypeDialog"));
        }
    }

    public static TypeSelectionDialog createObjectClassSelector(Entity entity) {
        TypeSelectionDialog typeSelectionDialog;
        Entity entity2 = ObjectClassHelper.getInstantiatedClass(entity);
        IType[] iTypeArray = new IType[]{};
        if (entity2 != null && (typeSelectionDialog = JavaElementUtil.model2javaType((Element)entity2)) != null) {
            iTypeArray = new IType[]{typeSelectionDialog};
        }
        typeSelectionDialog = CdlUI.getTypeDialog();
        GenericSearchSupport genericSearchSupport = new GenericSearchSupport((Element)entity);
        typeSelectionDialog.setScope((IJavaElement[])genericSearchSupport.getScopeRoots());
        typeSelectionDialog.setCurrentSelection(iTypeArray);
        return typeSelectionDialog;
    }

    public static TypeSelectionDialog createTypeSelector(ISearchSupport iSearchSupport, IType iType) {
        TypeSelectionDialog typeSelectionDialog = CdlUI.getTypeDialog();
        typeSelectionDialog.setScope((IJavaElement[])iSearchSupport.getScopeRoots());
        IType[] iTypeArray = new IType[]{};
        if (iType != null) {
            iTypeArray = new IType[]{iType};
        }
        typeSelectionDialog.setCurrentSelection(iTypeArray);
        return typeSelectionDialog;
    }
}

