/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.core;

import com.togethersoft.togetherxj.uml.cdl.util.Assert;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.togethersoft.togetherxj.uml.cdl.util.ModelElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IType;

public class ObjectClassHelper {
    private static final List EMPTY_LIST = Collections.unmodifiableList(new ArrayList());

    public static boolean hasInstantiationLinks(Entity entity) {
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            String string = entity2.getPropertyValue("$metaclass");
            if (!"Dependency Link".equals(string)) continue;
            Entity entity3 = ModelElementUtil.getLinkTarget(entity2);
            if (entity3 == null) {
                return true;
            }
            String string2 = entity3.getPropertyValue("$metaclass");
            if (!"Class".equals(string2) && !"Interface".equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static Entity getInstantiationLink(Entity entity) {
        List list = ObjectClassHelper.getAllDependencyLinks(entity);
        if (list == EMPTY_LIST) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            Entity entity2 = (Entity)iterator.next();
            Entity entity3 = ModelElementUtil.getLinkTarget(entity2);
            if (entity3 == null || !"Class".equals(string = entity3.getPropertyValue("$metaclass")) && !"Interface".equals(string)) continue;
            return entity2;
        }
        return null;
    }

    public static boolean hasInstantiatedClass(Entity entity) {
        return ObjectClassHelper.getInstantiatedClass(entity) != null;
    }

    public static Entity getInstantiatedClass(Entity entity) {
        Entity entity2;
        Entity entity3 = ObjectClassHelper.getInstantiationLink(entity);
        if (entity3 != null && (entity2 = ModelElementUtil.getLinkTarget(entity3)) != null && entity2.getParent() != null) {
            return entity2;
        }
        return null;
    }

    public static IType getInstantiatedType(Entity entity) {
        Entity entity2 = ObjectClassHelper.getInstantiatedClass(entity);
        if (entity2 != null) {
            return JavaElementUtil.model2javaType((Element)entity2);
        }
        return null;
    }

    public static void setInstantiatedType(Entity entity, IType iType) {
        if (iType == null) {
            ObjectClassHelper.setInstantiatedClass(entity, null);
            return;
        }
        Entity entity2 = (Entity)JavaElementUtil.javaType2model((Element)entity, iType);
        Assert.assertNotNull("Can't find model entity for type " + iType.getFullyQualifiedName(), entity2);
        ObjectClassHelper.setInstantiatedClass(entity, entity2);
    }

    public static void setInstantiatedClass(Entity entity, Entity entity2) {
        ObjectClassHelper.removeCorruptedLinks(entity);
        Entity entity3 = ObjectClassHelper.getInstantiationLink(entity);
        if (entity3 != null) {
            Assert.assertCanDelete(entity3);
            entity3.delete();
        }
        if (entity2 != null) {
            ModelElementUtil.createLink(entity, entity2, "Dependency Link");
        }
    }

    protected static List getAllDependencyLinks(Entity entity) {
        ArrayList<Entity> arrayList = null;
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            String string = entity2.getPropertyValue("$metaclass");
            if (!"Dependency Link".equals(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Entity>();
            }
            arrayList.add(entity2);
        }
        if (arrayList != null) {
            return arrayList;
        }
        return EMPTY_LIST;
    }

    public static Entity getBaseModelPackage(Entity entity) {
        Entity entity2 = ObjectClassHelper.getInstantiatedClass(entity);
        if (entity2 != null) {
            return entity2.getParent();
        }
        Entity entity3 = entity.getParent();
        while (entity3 != null && !entity3.hasPropertyValue("$metaclass", "Package") && !entity3.hasPropertyValue("$metaclass", "Model")) {
            entity3 = entity3.getParent();
        }
        return entity3;
    }

    protected static void removeCorruptedLinks(Entity entity) {
        Iterator iterator = ObjectClassHelper.getAllDependencyLinks(entity).iterator();
        while (iterator.hasNext()) {
            Entity entity2 = (Entity)iterator.next();
            if (ModelElementUtil.getLinkTarget(entity2) != null) continue;
            entity2.delete();
        }
    }
}

