/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.core;

import com.togethersoft.togetherxj.uml.cdl.core.MessageOperation;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationConnector;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationStatus$OK;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationStatus$TARGET_CLASS_NOT_FOUND;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationStatus$TARGET_NOT_LINKED_TO_CALSS;
import com.togethersoft.togetherxj.uml.cdl.core.ObjectClassHelper;
import com.togethersoft.togetherxj.uml.cdl.util.Assert;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.togethersoft.togetherxj.uml.cdl.util.ModelElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class MessageOperationHelper {
    public static IStatus checkTargetClass(Entity entity) {
        Entity entity2 = ModelElementUtil.getLinkTarget(entity);
        if (!ObjectClassHelper.hasInstantiationLinks(entity2)) {
            return new MessageOperationStatus$TARGET_NOT_LINKED_TO_CALSS("Target Object isn't linked with a Class");
        }
        Entity entity3 = ObjectClassHelper.getInstantiatedClass(entity2);
        if (entity3 == null) {
            return new MessageOperationStatus$TARGET_CLASS_NOT_FOUND("Target Class not found");
        }
        return new MessageOperationStatus$OK();
    }

    public static Entity getTargetClass(Entity entity) {
        Entity entity2 = ModelElementUtil.getLinkTarget(entity);
        if (entity2 != null) {
            return ObjectClassHelper.getInstantiatedClass(entity2);
        }
        return null;
    }

    public static IType getTargetType(Entity entity) {
        Entity entity2 = MessageOperationHelper.getTargetClass(entity);
        if (entity2 != null) {
            return JavaElementUtil.model2javaType((Element)entity2);
        }
        return null;
    }

    public static void setMethodToMessage(Entity entity, IMethod iMethod) {
        MessageOperationConnector messageOperationConnector = new MessageOperationConnector(entity);
        if (iMethod != null) {
            messageOperationConnector.setMethod(iMethod);
            messageOperationConnector.update();
        } else {
            messageOperationConnector.delete();
        }
    }

    public static void setOperationToMessage(Entity entity, Entity entity2) {
        IMethod iMethod = JavaElementUtil.model2javaMethod((Element)entity2);
        Assert.assertNotNull("Coudn't find method for element: " + entity2.getPropertyValue("$name"), iMethod);
        MessageOperationConnector messageOperationConnector = new MessageOperationConnector(entity);
        messageOperationConnector.setMethod(iMethod);
        messageOperationConnector.update();
    }

    public static MessageOperation getMessageOperation(Entity entity) {
        MessageOperationConnector messageOperationConnector = new MessageOperationConnector(entity);
        return messageOperationConnector.getMessageOperation();
    }

    public static MessageOperation getMessageOperation(Entity entity, IMethod iMethod) {
        MessageOperation messageOperation = new MessageOperation(iMethod);
        messageOperation.setSuperOverridden(MessageOperationHelper.isOverriddenInTarget(entity, iMethod));
        return messageOperation;
    }

    public static MessageOperation getMessageOperation(IMethod iMethod) {
        return new MessageOperation(iMethod);
    }

    public static boolean isOverriddenInTarget(Entity entity, IMethod iMethod) {
        IType iType = MessageOperationHelper.getTargetType(entity);
        if (iType == null) {
            return false;
        }
        IType iType2 = iMethod.getDeclaringType();
        if (iType.equals(iType2)) {
            return false;
        }
        return JavaElementUtil.isOverriddenMethod(iType, iMethod);
    }
}

