/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.core;

import com.togethersoft.togetherxj.uml.cdl.core.CdlStatus;
import com.togethersoft.togetherxj.uml.cdl.core.GenericSearchSupport;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperation;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationHelper;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class MessageOperationConnector {
    private Entity myMessage;
    private String myDeclTypeFQName;
    private String myMethodPresentationName;
    private String myMethodSignature;
    private boolean myToSuperOverridden;
    private boolean myConstructor;
    private IStatus myStatus = new CdlStatus(0, 0, null);
    private IType myDeclType;
    private IMethod myMethod;
    private MessageOperation myMessageOperation;
    private GenericSearchSupport mySearchSupport;

    public MessageOperationConnector(Entity entity) {
        Object object;
        Entity entity2;
        this.myMessage = entity;
        this.mySearchSupport = new GenericSearchSupport((Element)entity);
        Entity entity3 = null;
        EntityEnumeration entityEnumeration = this.myMessage.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            entity2 = entityEnumeration.next();
            if (!"Dependency Link".equals(entity2.getPropertyValue("$metaclass"))) continue;
            object = entity2.participants("Supplier");
            if (object.hasMoreElements()) {
                entity3 = (Entity)object.next();
            }
            if (entity3 != null) break;
            String string = "Internal error: dependency link to operatoin is corrupted";
            this.myStatus = new CdlStatus(4, 0, string);
            break;
        }
        entity2 = null;
        if (entity3 != null) {
            entity2 = JavaElementUtil.model2javaMethod(entity3);
            if (entity2 == null) {
                object = "Internal error: couldn't find JDT method for model element " + entity3.getPropertyValue("$metaclass") + " '" + entity3.getPropertyValue("$name") + "'";
                this.myStatus = new CdlStatus(4, 0, (String)object);
            } else {
                this.setMethod((IMethod)entity2);
            }
        }
        if (entity2 == null) {
            this.myDeclTypeFQName = this.getProperty((PropertyMap)entity, "operationDeclaringClass");
            this.myMethodPresentationName = this.getProperty((PropertyMap)entity, "operationName");
            this.myMethodSignature = this.getProperty((PropertyMap)entity, "operationSignature");
            this.myMessageOperation = new MessageOperation(this.myMethodPresentationName, this.myMethodSignature);
            this.myConstructor = this.myMessageOperation.isConstructor();
            this.myToSuperOverridden = this.myMessageOperation.isSuperOverridden();
        }
    }

    public IStatus getStatus() {
        return this.myStatus;
    }

    public boolean isEmpty() {
        return this.myMethodSignature == null || this.myMethodPresentationName == null;
    }

    public boolean isPureText() {
        return this.myDeclTypeFQName == null;
    }

    public void convertToPureText() {
        this.setMethodDeclaringType(null);
    }

    public boolean isConstructor() {
        return this.myConstructor;
    }

    public String getMethodSignature() {
        return this.myMethodSignature;
    }

    public void setMethodOfSuper(boolean bl) {
        this.myToSuperOverridden = bl;
    }

    protected void setMethodDeclaringType(IType iType) {
        this.myDeclType = iType;
        this.myDeclTypeFQName = iType != null ? iType.getFullyQualifiedName() : (String)null;
    }

    public void setMethod(IMethod iMethod) {
        try {
            IType iType = iMethod.getDeclaringType();
            boolean bl = iMethod.isConstructor();
            MessageOperation messageOperation = new MessageOperation(iMethod);
            messageOperation.setSuperOverridden(MessageOperationHelper.isOverriddenInTarget(this.myMessage, iMethod));
            String string = messageOperation.getPresentationName();
            String string2 = messageOperation.getSignature();
            this.myMethod = iMethod;
            this.setMethodDeclaringType(iType);
            this.myConstructor = bl;
            this.myMethodSignature = string2;
            this.myMethodPresentationName = string;
            this.myMessageOperation = messageOperation;
            this.myToSuperOverridden = messageOperation.isSuperOverridden();
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    public IMethod getMethod() {
        if (this.myMethod != null) {
            return this.myMethod;
        }
        IMethod iMethod = this.findMethod();
        if (iMethod != null) {
            this.setMethod(iMethod);
        }
        return iMethod;
    }

    public void setMessageOperation(MessageOperation messageOperation) {
        IMethod iMethod = messageOperation.getMethod();
        if (iMethod != null) {
            this.setMethod(iMethod);
        } else {
            this.myMethod = null;
            this.setMethodDeclaringType(null);
            this.myMethodSignature = messageOperation.getSignature();
            this.myMethodPresentationName = messageOperation.getPresentationName();
            this.myConstructor = messageOperation.isConstructor();
            this.myToSuperOverridden = messageOperation.isSuperOverridden();
            this.myMessageOperation = messageOperation;
        }
    }

    public MessageOperation getMessageOperation() {
        return this.myMessageOperation;
    }

    public void delete() {
        this.myMessage.setPropertyValue("operationDeclaringClass", null);
        this.myMessage.setPropertyValue("operationName", null);
        this.myMessage.setPropertyValue("operationSignature", null);
        EntityEnumeration entityEnumeration = this.myMessage.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity = entityEnumeration.next();
            if (!"Dependency Link".equals(entity.getPropertyValue("$metaclass"))) continue;
            entity.delete();
        }
    }

    public void update() {
        if (this.myMethodSignature == null || this.myMethodSignature.trim().length() == 0) {
            this.delete();
        } else {
            this.myMessage.setPropertyValue("operationDeclaringClass", this.myDeclTypeFQName);
            this.myMessage.setPropertyValue("operationSignature", this.myMethodSignature);
            this.updateDependencyLink(this.myMethod);
        }
        this.myMessage.setPropertyValue("operationName", this.myMethodPresentationName);
    }

    private void updateDependencyLink(IMethod iMethod) {
        Entity entity;
        if (iMethod == null || this.isPureText()) {
            EntityEnumeration entityEnumeration = this.myMessage.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                Entity entity2 = entityEnumeration.next();
                if (!"Dependency Link".equals(entity2.getPropertyValue("$metaclass"))) continue;
                entity2.delete();
            }
            return;
        }
        Entity entity3 = (Entity)this.mySearchSupport.searchMethodElement(iMethod);
        boolean bl = entity3 == null;
        Entity entity4 = null;
        EntityEnumeration entityEnumeration = this.myMessage.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            entity = entityEnumeration.next();
            if (entity.isDeleted() || !"Dependency Link".equals(entity.getPropertyValue("$metaclass"))) continue;
            if (bl) {
                entity.delete();
                continue;
            }
            entity4 = entity;
            ElementEnumeration elementEnumeration = entity4.participants("Supplier");
            if (elementEnumeration.hasMoreElements()) {
                Element element = elementEnumeration.next();
                if (entity3 != null && element != null && element.getUniqueName().equals(entity3.getUniqueName())) continue;
                entity4.delete();
                entity4 = null;
                continue;
            }
            entity4.delete();
            entity4 = null;
        }
        if (entity3 != null && entity4 == null) {
            entity = this.myMessage.getModel().createEntityTemplate();
            entity.setParticipant("Client", null, (Element)this.myMessage);
            entity.setParticipant("Supplier", null, (Element)entity3);
            this.myMessage.createChildEntity("Dependency Link", entity);
        }
    }

    public String getDeclaringTypeName() {
        return this.myDeclTypeFQName;
    }

    public IType getDeclaringType() {
        if (this.myDeclType == null && this.myDeclTypeFQName != null) {
            this.myDeclType = this.mySearchSupport.searchType(this.myDeclTypeFQName);
        }
        return this.myDeclType;
    }

    protected IMethod findMethod() {
        IType iType = this.getDeclaringType();
        if (iType == null) {
            return null;
        }
        MessageOperation messageOperation = new MessageOperation(this.myMethodPresentationName, this.myMethodSignature);
        if (messageOperation.isSuperOverridden()) {
            return null;
        }
        try {
            return JavaElementUtil.findMethod(this.myMethodPresentationName, messageOperation.getParametersTypes(), this.myConstructor, iType.getMethods());
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
            return null;
        }
    }

    protected String getOperationUID(IMethod iMethod) {
        Element element = this.mySearchSupport.searchMethodElement(iMethod);
        String string = element.getUniqueName().toString();
        return string;
    }

    protected String getProperty(PropertyMap propertyMap, String string) {
        String string2 = propertyMap.getPropertyValue(string);
        if (string2 != null && string2.trim().length() == 0) {
            return null;
        }
        return string2;
    }
}

