/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.cdl.core;

import com.togethersoft.togetherxj.uml.cdl.core.MethodParameterData;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class MessageOperation {
    public static final String NOTATION_CONSTRUCTOR = "<constructor>";
    public static final String NOTATION_UNDEFINED = "<undefined>";
    public static final String NOTATION_SUPER = "<super>";
    public static final MessageOperation EMPTY = new MessageOperation(null, null);
    private String myCreatedFrom;
    private IMethod myMethod;
    private String myMethodPresentationSignature;
    private String myMethodSignature;
    private String myMethodName;
    private boolean myConstructor;
    private boolean mySuperOverridden;

    public MessageOperation(IMethod iMethod) {
        this.myCreatedFrom = "<from method>";
        try {
            this.myConstructor = iMethod.isConstructor();
            this.myMethod = iMethod;
            this.myMethodName = this.myConstructor ? NOTATION_CONSTRUCTOR : this.myMethod.getElementName();
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    public MessageOperation(String string, String string2, boolean bl) {
        this(string, string2);
    }

    public MessageOperation(String string, String string2) {
        this.myCreatedFrom = "<from name>: " + string;
        this.myMethodName = string;
        if (this.myMethodName != null) {
            this.myConstructor = this.myMethodName.indexOf(NOTATION_CONSTRUCTOR) >= 0;
            boolean bl = this.mySuperOverridden = this.myMethodName.indexOf(NOTATION_SUPER) >= 0;
            if (this.mySuperOverridden) {
                String string3 = "";
                int n = this.myMethodName.indexOf(NOTATION_SUPER);
                int n2 = n + NOTATION_SUPER.length();
                if (n > 0) {
                    string3 = this.myMethodName.substring(0, n);
                }
                this.myMethodName = string3 + this.myMethodName.substring(n2);
            }
        }
        this.myMethodSignature = string2;
    }

    public boolean isConstructor() {
        return this.myConstructor;
    }

    public void setSuperOverridden(boolean bl) {
        this.mySuperOverridden = bl;
    }

    public boolean isSuperOverridden() {
        return this.mySuperOverridden;
    }

    public boolean isEmpty() {
        return this.myMethod == null && this.myMethodName == null;
    }

    public IMethod getMethod() {
        return this.myMethod;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public String getPresentationName() {
        if (this.myMethodName == null) {
            return NOTATION_UNDEFINED;
        }
        if (this.mySuperOverridden) {
            return NOTATION_SUPER + this.myMethodName;
        }
        return this.myMethodName;
    }

    public String getPresentationSignature() {
        if (this.myMethodPresentationSignature == null) {
            this.myMethodPresentationSignature = this.createPresentationSignature(null);
        }
        return this.myMethodPresentationSignature;
    }

    public String getPresentationSignature(String string) {
        return this.createPresentationSignature(string);
    }

    protected String createPresentationSignature(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.getParametersPresentation(this.myMethod != null);
        }
        String string3 = null;
        string3 = this.myMethod == null ? this.getPresentationName() + "(" + string2 + ")" : this.createMethodPresentationSignature(this.myMethod, string2);
        return string3;
    }

    public String getSignature() {
        if (this.myMethodSignature == null && this.myMethod != null) {
            try {
                this.myMethodSignature = Signature.createMethodSignature((String[])this.myMethod.getParameterTypes(), (String)this.myMethod.getReturnType());
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
        }
        return this.myMethodSignature;
    }

    public String[] getParametersTypes() {
        if (this.getSignature() != null) {
            return Signature.getParameterTypes((String)this.getSignature());
        }
        return new String[0];
    }

    public String getReturnType() {
        if (this.getSignature() != null) {
            return Signature.getReturnType((String)this.getSignature());
        }
        return null;
    }

    public String[] getParametersTypeNames() {
        String[] stringArray = this.getParametersTypes();
        if (stringArray.length == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = Signature.toString((String)stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    public String getReturnTypeName() {
        String string = this.getReturnType();
        if (string == null || string.length() == 0) {
            return "void";
        }
        return Signature.toString((String)string);
    }

    protected String createMethodPresentationSignature(IMethod iMethod, String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getPresentationName());
        stringBuffer.append('(');
        stringBuffer.append(string);
        stringBuffer.append(')');
        try {
            if (!iMethod.isConstructor()) {
                stringBuffer.append(':');
                stringBuffer.append(Signature.toString((String)iMethod.getReturnType()));
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public String getParametersPresentation(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getParametersTypes();
        String[] stringArray2 = null;
        if (bl && this.myMethod != null && this.myMethod.exists()) {
            try {
                stringArray2 = this.myMethod.getParameterNames();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(Signature.getSimpleName((String)Signature.toString((String)stringArray[n])));
            if (stringArray2 != null) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray2[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public MethodParameterData[] getParameters() {
        String[] stringArray = this.getParametersTypes();
        String[] stringArray2 = null;
        if (this.myMethod != null && this.myMethod.exists()) {
            try {
                stringArray2 = this.myMethod.getParameterNames();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        if (stringArray2 == null) {
            stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = "arg" + n;
                ++n;
            }
        }
        MethodParameterData[] methodParameterDataArray = new MethodParameterData[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            methodParameterDataArray[n] = new MethodParameterData(stringArray[n], stringArray2[n]);
            ++n;
        }
        return methodParameterDataArray;
    }

    protected String[] convertTypeNamesToSigs(char[][] cArray) {
        if (cArray == null || cArray.length == 0) {
            return new String[0];
        }
        int n = cArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Signature.createTypeSignature((char[])cArray[n2], (boolean)false);
            ++n2;
        }
        return stringArray;
    }

    public String toString() {
        return "MessageOperation" + this.myCreatedFrom + (this.isEmpty() ? "[EMPTY]" : "") + (this.isSuperOverridden() ? "[SUPER]" : "") + (this.isConstructor() ? "[CONSTR]" : "") + ": " + this.getPresentationName() + "[" + this.getSignature() + "] :" + this.getPresentationSignature();
    }
}

