/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.util;

import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Query {
    private List queries = new ArrayList();

    public Query() {
    }

    public Query(String s) {
        if (s != null) {
            String query = Encoder.decodeQuery(s);
            List params = Tokenizer.partsOf(query, "&", 0, 61);
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Pair param = (Pair)it.next();
                this.appendQueryParameter(param);
            }
        }
    }

    public boolean isEmpty() {
        return this.queries.size() == 0;
    }

    public void appendQuery(Query query) {
        if (query != null) {
            Iterator it = query.iterator();
            while (it.hasNext()) {
                Pair queryParam = (Pair)it.next();
                this.appendQueryParameter(queryParam);
            }
        }
    }

    public void appendQueryParameter(String name, String value) {
        this.appendQueryParameter(new Pair(name, value, '='));
    }

    public void appendQueryParameter(Pair parameter) {
        Pair p = this.getQueryParameter(parameter.getName());
        if (p != null) {
            p.setValue(parameter.getValue());
        } else {
            this.queries.add(parameter);
        }
    }

    public Pair getQueryParameter(String name) {
        Iterator it = this.queries.iterator();
        while (it.hasNext()) {
            Pair q = (Pair)it.next();
            if (!name.equalsIgnoreCase(q.getName())) continue;
            return q;
        }
        return null;
    }

    public void removeQueryParameter(String name) {
        Iterator it = this.queries.iterator();
        while (it.hasNext()) {
            Pair q = (Pair)it.next();
            if (!name.equalsIgnoreCase(q.getName())) continue;
            it.remove();
        }
    }

    public Iterator iterator() {
        return this.queries.iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.queries.size() > 0) {
            int i = 0;
            Iterator it = this.queries.iterator();
            while (it.hasNext()) {
                if (i > 0) {
                    sb.append("&");
                }
                Pair param = (Pair)it.next();
                sb.append(Encoder.encodeQuery(param.getName()));
                sb.append("=");
                sb.append(Encoder.encodeQuery(param.getValue()));
                ++i;
            }
        }
        return sb.toString();
    }
}

