/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.util;

import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.util.Collections;
import java.util.List;

public class Pair {
    protected String name;
    protected String value;
    protected List parts;
    protected char separator;
    protected String partSeparators;

    public Pair(String name, String value, char separator) {
        this.separator = separator;
        this.name = name;
        this.value = value;
    }

    public Pair(String str, char separator) {
        this.separator = separator;
        this.initializeFrom(str, false);
    }

    public Pair(String str, char separator, boolean removeQuotes) {
        this.separator = separator;
        this.initializeFrom(str, removeQuotes);
    }

    public static Pair valueOf(String str, char separator) {
        Pair pair = new Pair(separator);
        pair.initializeFrom(str, false);
        return pair;
    }

    public static Pair valueOf(String str, char separator, boolean removeQuotes) {
        Pair pair = new Pair(separator);
        pair.initializeFrom(str, removeQuotes);
        return pair;
    }

    private Pair(char separator) {
        this.separator = separator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (this.parts != null) {
            this.parts.clear();
            this.parts = null;
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getPartSeparators() {
        return this.partSeparators;
    }

    public void setPartSeparators(String partSeparators) {
        this.partSeparators = partSeparators;
        if (this.parts != null) {
            this.parts.clear();
            this.parts = null;
        }
    }

    public List getParts() {
        if (this.parts == null) {
            this.parts = Tokenizer.partsOf(this.value, this.getPartSeparators());
        }
        return Collections.unmodifiableList(this.parts);
    }

    public void appendPart(String part, String separator) {
        this.value = this.value == null || this.value.length() == 0 ? part : (separator != null && separator.length() > 0 ? this.value + separator + part : (this.partSeparators != null && this.partSeparators.length() > 0 ? this.value + this.partSeparators.charAt(0) + part : this.value + part));
        if (this.parts != null) {
            this.parts.add(part);
        }
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Pair) {
            Pair pair = (Pair)o;
            boolean equals = true;
            equals &= this.name != null ? this.name.equals(pair.getName()) : pair.getName() == null;
            return equals &= this.value != null ? this.value.equals(pair.getValue()) : pair.getValue() == null;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = this.name != null ? 37 * result + this.name.hashCode() : result;
        result = this.value != null ? 37 * result + this.value.hashCode() : result;
        return result;
    }

    public String toString() {
        if (this.value != null && this.value.length() > 0) {
            return this.name + this.getSeparator() + this.value;
        }
        return this.name;
    }

    private void initializeFrom(String str, boolean removeQuotes) {
        if (str != null) {
            int pos = str.indexOf(this.getSeparator());
            if (pos > 0) {
                this.name = str.substring(0, pos).trim();
                this.value = pos < str.length() - 1 ? str.substring(pos + 1).trim() : "";
            } else if (pos == 0) {
                this.name = "";
                this.value = str.substring(1).trim();
            } else {
                this.name = str;
                this.value = "";
            }
            if (removeQuotes && (this.value.startsWith("\"") && this.value.endsWith("\"") || this.value.startsWith("'") && this.value.endsWith("'"))) {
                this.value = this.value.substring(1, this.value.length() - 1);
            }
        }
    }
}

