/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public final class Encoder {
    private static String defaultEncoding = new InputStreamReader(new NullStream()).getEncoding();
    private static final char[] nibbleChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] digits = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final char[] map0 = new char[]{'A', 'A', 'A', 'A', 'B', 'B', 'B', 'B', 'C', 'C', 'C', 'C', 'D', 'D', 'D', 'D', 'E', 'E', 'E', 'E', 'F', 'F', 'F', 'F', 'G', 'G', 'G', 'G', 'H', 'H', 'H', 'H', 'I', 'I', 'I', 'I', 'J', 'J', 'J', 'J', 'K', 'K', 'K', 'K', 'L', 'L', 'L', 'L', 'M', 'M', 'M', 'M', 'N', 'N', 'N', 'N', 'O', 'O', 'O', 'O', 'P', 'P', 'P', 'P', 'Q', 'Q', 'Q', 'Q', 'R', 'R', 'R', 'R', 'S', 'S', 'S', 'S', 'T', 'T', 'T', 'T', 'U', 'U', 'U', 'U', 'V', 'V', 'V', 'V', 'W', 'W', 'W', 'W', 'X', 'X', 'X', 'X', 'Y', 'Y', 'Y', 'Y', 'Z', 'Z', 'Z', 'Z', 'a', 'a', 'a', 'a', 'b', 'b', 'b', 'b', 'c', 'c', 'c', 'c', 'd', 'd', 'd', 'd', 'e', 'e', 'e', 'e', 'f', 'f', 'f', 'f', 'g', 'g', 'g', 'g', 'h', 'h', 'h', 'h', 'i', 'i', 'i', 'i', 'j', 'j', 'j', 'j', 'k', 'k', 'k', 'k', 'l', 'l', 'l', 'l', 'm', 'm', 'm', 'm', 'n', 'n', 'n', 'n', 'o', 'o', 'o', 'o', 'p', 'p', 'p', 'p', 'q', 'q', 'q', 'q', 'r', 'r', 'r', 'r', 's', 's', 's', 's', 't', 't', 't', 't', 'u', 'u', 'u', 'u', 'v', 'v', 'v', 'v', 'w', 'w', 'w', 'w', 'x', 'x', 'x', 'x', 'y', 'y', 'y', 'y', 'z', 'z', 'z', 'z', '0', '0', '0', '0', '1', '1', '1', '1', '2', '2', '2', '2', '3', '3', '3', '3', '4', '4', '4', '4', '5', '5', '5', '5', '6', '6', '6', '6', '7', '7', '7', '7', '8', '8', '8', '8', '9', '9', '9', '9', '+', '+', '+', '+', '/', '/', '/', '/'};
    private static final char[] map1 = new char[]{'A', 'Q', 'g', 'w', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'B', 'R', 'h', 'x', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'C', 'S', 'i', 'y', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'D', 'T', 'j', 'z', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'E', 'U', 'k', '0', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'F', 'V', 'l', '1', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'G', 'W', 'm', '2', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'H', 'X', 'n', '3', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'I', 'Y', 'o', '4', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'J', 'Z', 'p', '5', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'K', 'a', 'q', '6', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'L', 'b', 'r', '7', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'M', 'c', 's', '8', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'N', 'd', 't', '9', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'O', 'e', 'u', '+', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'P', 'f', 'v', '/', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final char[] map2 = new char[]{'A', 'E', 'I', 'M', 'Q', 'U', 'Y', 'c', 'g', 'k', 'o', 's', 'w', '0', '4', '8', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'B', 'F', 'J', 'N', 'R', 'V', 'Z', 'd', 'h', 'l', 'p', 't', 'x', '1', '5', '9', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'C', 'G', 'K', 'O', 'S', 'W', 'a', 'e', 'i', 'm', 'q', 'u', 'y', '2', '6', '+', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'D', 'H', 'L', 'P', 'T', 'X', 'b', 'f', 'j', 'n', 'r', 'v', 'z', '3', '7', '/', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final char[] map3 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] rmap = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};

    public static String encodePath(String s) {
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
            } else if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
            } else if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
            } else if (ch == '/' || ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '$') {
                sbuf.append(ch);
            } else if (ch <= '\u007f') {
                sbuf.append(hex[ch]);
            } else if (ch <= '\u07ff') {
                sbuf.append(hex[0xC0 | ch >> 6]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            } else {
                sbuf.append(hex[0xE0 | ch >> 12]);
                sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String decodePath(String s) {
        StringBuffer sbuf = new StringBuffer();
        int l = s.length();
        int ch = -1;
        int sumb = 0;
        int i = 0;
        int more = -1;
        while (i < l) {
            int b;
            char c = s.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = s.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more == 0) {
                    sbuf.append((char)sumb);
                }
            } else if ((b & 0x80) == 0) {
                sbuf.append((char)b);
            } else if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
            } else if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
            } else if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
            } else if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
            } else {
                sumb = b & 1;
                more = 5;
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String encodeQuery(String s) {
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
            } else if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
            } else if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
            } else if (' ' == ch) {
                sbuf.append('+');
            } else if (ch == '-' || ch == '_' || ch == '.') {
                sbuf.append(ch);
            } else if (ch <= '\u007f') {
                sbuf.append(hex[ch]);
            } else if (ch <= '\u07ff') {
                sbuf.append(hex[0xC0 | ch >> 6]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            } else {
                sbuf.append(hex[0xE0 | ch >> 12]);
                sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String decodeQuery(String s) {
        StringBuffer sbuf = new StringBuffer();
        int l = s.length();
        int ch = -1;
        int sumb = 0;
        int i = 0;
        int more = -1;
        while (i < l) {
            int b;
            char c = s.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = s.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case '+': {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more == 0) {
                    sbuf.append((char)sumb);
                }
            } else if ((b & 0x80) == 0) {
                sbuf.append((char)b);
            } else if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
            } else if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
            } else if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
            } else if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
            } else {
                sumb = b & 1;
                more = 5;
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String encodeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\'': {
                    buffer.append("&apos;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(s.charAt(i));
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String encodeBase64(String buffer) {
        return Encoder.encodeBase64(buffer.getBytes());
    }

    public static String encodeBase64(byte[] buffer) {
        StringBuffer sb = new StringBuffer((buffer.length + 2) / 3 * 4);
        int group = 0;
        int mode = 0;
        int last = 0;
        int i = 0;
        while (i < buffer.length) {
            int b = buffer[i] & 0xFF;
            switch (mode) {
                case 0: {
                    if (++group == 19) {
                        sb.append("\r\n");
                        group = 0;
                    }
                    sb.append(map0[b]);
                    last = b & 3;
                    mode = 1;
                    break;
                }
                case 1: {
                    sb.append(map1[last | b & 0xF0]);
                    last = b & 0xF;
                    mode = 2;
                    break;
                }
                case 2: {
                    sb.append(map2[last | b & 0xC0]);
                    sb.append(map3[b]);
                    mode = 0;
                    break;
                }
            }
            ++i;
        }
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(map1[last]);
                sb.append("==");
                break;
            }
            case 2: {
                sb.append(map2[last]);
                sb.append('=');
                break;
            }
        }
        return sb.toString();
    }

    public static byte[] decodeBase64(String buffer) {
        int mode = 0;
        int len = buffer.length();
        byte[] result = new byte[len];
        int bytes = 0;
        byte b = 0;
        int offset = 0;
        int i = 0;
        while (i < len) {
            block13: {
                byte current;
                block12: {
                    char c = buffer.charAt(i);
                    current = 0;
                    if (c == '=') break block12;
                    current = (byte)rmap[c];
                    if (current < 0) break block13;
                    if (mode != 0) {
                        ++bytes;
                    }
                }
                switch (mode) {
                    case 0: {
                        b = (byte)(current << 2);
                        mode = 1;
                        break;
                    }
                    case 1: {
                        b = (byte)(b | (current & 0xF0) >>> 4);
                        result[offset++] = b;
                        b = (byte)((current & 0xF) << 4);
                        mode = 2;
                        break;
                    }
                    case 2: {
                        b = (byte)(b | (current & 0xFC) >>> 2);
                        result[offset++] = b;
                        b = (byte)((current & 3) << 6);
                        mode = 3;
                        break;
                    }
                    case 3: {
                        b = (byte)(b | current);
                        result[offset++] = b;
                        mode = 0;
                        break;
                    }
                }
            }
            ++i;
        }
        if (mode != 0) {
            return null;
        }
        byte[] bs = new byte[bytes];
        System.arraycopy(result, 0, bs, 0, bytes);
        return bs;
    }

    public static String toHexString(int value) {
        char[] chars = new char[8];
        int i = 7;
        while (i >= 0) {
            chars[i] = nibbleChar[value & 0xF];
            value >>>= 4;
            --i;
        }
        return new String(chars);
    }

    public static String toHexString(byte[] buffer) {
        StringBuffer sb = new StringBuffer(buffer.length * 2);
        int i = 0;
        while (i < buffer.length) {
            sb.append(nibbleChar[(buffer[i] & 0xF0) >> 4]);
            sb.append(nibbleChar[buffer[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] encodeHex(int value) {
        byte[] sb = new byte[8];
        int i = 7;
        while (i >= 0) {
            sb[i] = (byte)nibbleChar[value & 0xF];
            value >>>= 4;
            --i;
        }
        return sb;
    }

    public static byte[] encodeHex(byte[] buffer) {
        byte[] sb = new byte[buffer.length * 2];
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            sb[j] = (byte)nibbleChar[(buffer[i] & 0xF0) >> 4];
            sb[j + 1] = (byte)nibbleChar[buffer[i] & 0xF];
            ++i;
            j += 2;
        }
        return sb;
    }

    public static int decodeHex(byte[] buffer, int off) {
        int d;
        int sum = 0;
        byte c = buffer[off];
        int n = d = c >= 48 && c < 112 ? digits[c - 48] : -1;
        if (d == -1) {
            return -1;
        }
        sum = d;
        int i = off + 1;
        int len = buffer.length;
        while (i < len && (c = buffer[i]) >= 48 && c < 112 && (d = digits[c - 48]) != -1) {
            sum <<= 4;
            sum += d;
            ++i;
        }
        return sum;
    }

    public static byte[] getBytes(String str, String enc) throws UnsupportedEncodingException {
        String encoding = enc == null || enc.length() == 0 ? defaultEncoding : enc;
        return str.getBytes(encoding);
    }

    public static byte[] getBytes(StringBuffer str, String enc) throws UnsupportedEncodingException {
        String encoding = enc == null || enc.length() == 0 ? defaultEncoding : enc;
        return str.toString().getBytes(encoding);
    }

    public static String getDefaultEncoding() {
        return defaultEncoding;
    }

    private static class NullStream
    extends InputStream {
        private NullStream() {
        }

        public int read() throws IOException {
            return 0;
        }
    }
}

