/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.streams;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;

public class ChunkedOutputStream
extends OutputStream
implements IRequestStream {
    public static final int DEFAULT_MSS_ETHERNET = 1460;
    public static final int DEFAULT_MTU_MODEM = 536;
    public static final int DEFAULT_MSS_PPPoE = 1452;
    public static final int MAX_MSS_TCP_IP = 65496;
    protected byte[] buf;
    protected int count;
    protected int size;
    private OutputStream out;
    private Socket socket;
    private boolean chunking;
    private long limit = -1L;
    private long total = 0L;
    private int offset = 0;
    private static final Location TRACE;
    public static final Location DEFAULT_WIRE_TRACE_LOCATION;
    private Location WIRE_TRACE_LOCATION = DEFAULT_WIRE_TRACE_LOCATION;
    private boolean wireTraceEnabled = false;
    private int traceOff;
    private static final byte[] CRLF;
    private static final byte[] LAST_CHUNK;
    private static final int OFFSET;
    private static final char[] HEX;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$streams$ChunkedOutputStream;

    public ChunkedOutputStream(Socket socket) throws IOException {
        this(socket, 1460);
    }

    public ChunkedOutputStream(Socket socket, int size) throws IOException {
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.setSize(size);
    }

    public ChunkedOutputStream(OutputStream out, int size) throws IOException {
        this.out = out;
        this.setSize(size);
    }

    public OutputStream asStream() {
        return this;
    }

    public int getSize() {
        return this.buf.length;
    }

    public void setSize(int sz) throws IOException {
        if (this.out == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("setSize(int)", (Throwable)ex);
            throw ex;
        }
        if (this.count > 0) {
            this.writeBuffer();
        }
        this.size = sz < 536 ? 536 : (sz > 65496 ? 65496 : sz);
        this.buf = new byte[this.size];
    }

    public void write(int b) throws IOException {
        if (this.out == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("write(int)", (Throwable)ex);
            throw ex;
        }
        if (this.count == this.size) {
            this.writeBuffer();
        }
        if (this.limit > 0L) {
            ++this.total;
            if (this.total > this.limit) {
                IOException ex = new IOException("number of bytes written to stream exceeds content length");
                TRACE.throwing("write(int)", (Throwable)ex);
                throw ex;
            }
        }
        this.buf[this.offset + this.count] = (byte)b;
        ++this.count;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int free;
        if (this.out == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("write(byte[],int,int", (Throwable)ex);
            throw ex;
        }
        if (this.count == this.size) {
            this.writeBuffer();
        }
        if (this.limit > 0L) {
            this.total += (long)len;
            if (this.total > this.limit) {
                IOException ex = new IOException("number of bytes written to stream exceeds content length.");
                TRACE.throwing("write(byte[],int,int)", (Throwable)ex);
                throw ex;
            }
        }
        if (len > (free = this.size - this.count)) {
            int pos = off;
            int cnt = len;
            System.arraycopy(b, off, this.buf, this.offset + this.count, free);
            this.count += free;
            this.writeBuffer();
            cnt -= free;
            pos += free;
            while (cnt >= this.size) {
                System.arraycopy(b, pos, this.buf, this.offset, this.size);
                this.count = this.size;
                this.writeBuffer();
                cnt -= this.size;
                pos += this.size;
            }
            if (cnt > 0) {
                System.arraycopy(b, pos, this.buf, this.offset, cnt);
            }
            this.count = cnt;
        } else {
            System.arraycopy(b, off, this.buf, this.offset + this.count, len);
            this.count += len;
        }
    }

    public void write(String s, String enc) throws IOException, UnsupportedEncodingException {
        if (this.out == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("write(String,String)", (Throwable)ex);
            throw ex;
        }
        byte[] b = s.getBytes(enc);
        this.write(b, 0, b.length);
    }

    public void write(InputStream source) throws IOException {
        if (this.out == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("write(InputStream)", (Throwable)ex);
            throw ex;
        }
        int read = source.read(this.buf, this.offset + this.count, this.size - this.count);
        while (read >= 0) {
            if (this.limit > 0L) {
                this.total += (long)read;
                if (this.total > this.limit) {
                    IOException ex = new IOException("number of bytes written to stream exceeds content length.");
                    TRACE.throwing("write(InputStream)", (Throwable)ex);
                    throw ex;
                }
            }
            this.count += read;
            if (this.count == this.size) {
                this.writeBuffer();
            }
            read = source.read(this.buf, this.offset + this.count, this.size - this.count);
        }
    }

    public void flush() throws IOException {
        if (this.out == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("write(InputStream)", (Throwable)ex);
            throw ex;
        }
        this.writeBuffer();
        if (this.chunking) {
            this.sendZeroChunk();
        }
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.enableChunking(false);
            this.disableLimit();
            this.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        try {
            try {
                this.close();
                this.socket.shutdownOutput();
            }
            catch (Exception ex) {
                TRACE.catching("shutdown()", (Throwable)ex);
                Object var3_2 = null;
                TRACE.debugT("shutdown()", "socket output stream [shutdown]");
                this.out = null;
                this.buf = null;
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TRACE.debugT("shutdown()", "socket output stream [shutdown]");
            this.out = null;
            this.buf = null;
            throw throwable;
        }
        TRACE.debugT("shutdown()", "socket output stream [shutdown]");
        this.out = null;
        this.buf = null;
    }

    public void enableChunking(boolean enable) throws IOException {
        if (this.chunking && enable || !this.chunking && !enable) {
            return;
        }
        if (enable) {
            if (this.limit > 0L) {
                this.disableLimit();
            }
            this.writeBuffer();
            this.size -= OFFSET;
            this.size -= CRLF.length;
            this.offset = OFFSET;
            this.buf[ChunkedOutputStream.OFFSET - 2] = CRLF[0];
            this.buf[ChunkedOutputStream.OFFSET - 1] = CRLF[1];
            this.buf[ChunkedOutputStream.OFFSET + this.size] = CRLF[0];
            this.buf[ChunkedOutputStream.OFFSET + this.size + 1] = CRLF[1];
            this.traceOff = OFFSET;
        } else if (this.chunking) {
            this.writeBuffer();
            this.sendZeroChunk();
            this.size += OFFSET;
            this.size += CRLF.length;
            this.offset = 0;
            this.traceOff = 0;
        }
        this.chunking = enable;
    }

    public boolean chunking() {
        return this.chunking;
    }

    public void enableLimit(long limit) throws IOException {
        if (this.chunking) {
            this.enableChunking(false);
        }
        this.limit = limit;
        this.total = 0L;
    }

    public void disableLimit() throws IOException {
        this.writeBuffer();
        if (this.limit > 0L && this.total < this.limit) {
            IOException ex = new IOException("number of bytes written to stream less than specified limit.");
            TRACE.throwing("disableLimit()", (Throwable)ex);
            throw ex;
        }
        this.limit = -1L;
    }

    public void enableWireTrace() {
        this.wireTraceEnabled = true;
        this.traceOff = this.count;
    }

    public void enableWireTrace(Location location) {
        this.enableWireTrace();
        if (location != null) {
            this.WIRE_TRACE_LOCATION = location;
        }
    }

    public void disableWireTrace() {
        this.wireTraceEnabled = false;
    }

    public boolean isWireTraceEnabled() {
        return this.wireTraceEnabled;
    }

    private void writeBuffer() throws IOException {
        if (this.count > 0) {
            int off = this.offset;
            int cnt = this.count;
            if (this.chunking) {
                int n = this.count;
                int i = OFFSET - 3;
                while (n > 0 && i >= 0) {
                    this.buf[i] = (byte)HEX[n & 0xF];
                    n >>>= 4;
                    --i;
                }
                off = i + 1;
                cnt = this.count + OFFSET - off;
                this.buf[ChunkedOutputStream.OFFSET + this.count] = CRLF[0];
                this.buf[ChunkedOutputStream.OFFSET + this.count + 1] = CRLF[1];
                cnt += CRLF.length;
            }
            this.out.write(this.buf, off, cnt);
            if (this.wireTraceEnabled && this.WIRE_TRACE_LOCATION.beDebug() && cnt > this.traceOff) {
                if (this.chunking) {
                    this.WIRE_TRACE_LOCATION.debugT("writeBuffer()", Integer.toString(this.count));
                }
                this.WIRE_TRACE_LOCATION.debugT("writeBuffer()", new String(this.buf, this.traceOff, cnt - this.traceOff));
                this.traceOff = this.chunking ? OFFSET : 0;
            }
            this.count = 0;
        }
    }

    private void sendZeroChunk() throws IOException {
        this.out.write(LAST_CHUNK, 0, LAST_CHUNK.length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_WIRE_TRACE_LOCATION = TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$streams$ChunkedOutputStream == null ? (class$com$tssap$dtr$client$lib$protocol$streams$ChunkedOutputStream = ChunkedOutputStream.class$("com.tssap.dtr.client.lib.protocol.streams.ChunkedOutputStream")) : class$com$tssap$dtr$client$lib$protocol$streams$ChunkedOutputStream));
        CRLF = "\r\n".getBytes();
        LAST_CHUNK = "0\r\n\r\n".getBytes();
        OFFSET = Integer.toHexString(65496).getBytes().length + CRLF.length;
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

