/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.streams;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;

public class ChunkedInputStream
extends InputStream
implements IResponseStream {
    public static final int DEFAULT_SIZE = 5840;
    protected byte[] buf;
    protected int count = 0;
    protected int pos = 0;
    private InputStream in;
    private Socket socket;
    private boolean limited = false;
    private long limit = -1L;
    private long toRead = -1L;
    private boolean chunking = false;
    private int chunkCount = -1;
    private static final Location TRACE;
    public static final Location DEFAULT_WIRE_TRACE_LOCATION;
    private Location WIRE_TRACE_LOCATION = DEFAULT_WIRE_TRACE_LOCATION;
    private boolean wireTraceEnabled = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$streams$ChunkedInputStream;

    public ChunkedInputStream(Socket socket) throws IOException {
        this(socket, 5840);
    }

    public ChunkedInputStream(Socket socket, int size) throws IOException {
        this.socket = socket;
        this.in = socket.getInputStream();
        this.buf = new byte[size];
    }

    public ChunkedInputStream(InputStream in, int size) throws IOException {
        this.in = in;
        this.buf = new byte[size];
    }

    public InputStream asStream() {
        return this;
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        return this.in.available() + this.count - this.pos;
    }

    public int read() throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        if (this.pos >= this.count) {
            this.fill();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        read = this.readAvailable(b, off, len);
        if (read > 0) ** GOTO lbl8
        return read;
        while ((cnt = this.readAvailable(b, off + read, len - read)) > 0) {
            read += cnt;
lbl8:
            // 2 sources

            if (read < len && this.in.available() > 0) continue;
        }
        if (read > 0 && ChunkedInputStream.TRACE.beDebug()) {
            ChunkedInputStream.TRACE.debugT("read(byte[],int,int)", "{0} bytes read", new Object[]{Integer.toString(read)});
        }
        return read;
    }

    /*
     * Unable to fully structure code
     */
    public int read(StringBuffer b, String enc) throws IOException, UnsupportedEncodingException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        if (!this.limited) {
            return -1;
        }
        read = this.readAvailable(b, enc);
        if (read > 0) ** GOTO lbl10
        return read;
        while ((cnt = this.readAvailable(b, enc)) > 0) {
            read += cnt;
lbl10:
            // 2 sources

            if (this.in.available() > 0) continue;
        }
        if (read > 0 && ChunkedInputStream.TRACE.beDebug()) {
            ChunkedInputStream.TRACE.debugT("read(StringBuffer,String)", "{0} bytes read", new Object[]{Integer.toString(read)});
        }
        return read;
    }

    /*
     * Unable to fully structure code
     */
    public int read(OutputStream destination) throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        if (!this.limited) {
            return -1;
        }
        read = this.readAvailable(destination);
        if (read > 0) ** GOTO lbl10
        return read;
        while ((cnt = this.readAvailable(destination)) > 0) {
            read += cnt;
lbl10:
            // 2 sources

            if (this.in.available() > 0) continue;
        }
        if (read > 0 && ChunkedInputStream.TRACE.beDebug()) {
            ChunkedInputStream.TRACE.debugT("read(OutputStream)", "{0} bytes read", new Object[]{Integer.toString(read)});
        }
        return read;
    }

    public String readLine(boolean skipEmptyLines, boolean skipWhitespace) throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        StringBuffer b = new StringBuffer();
        String result = null;
        boolean done = false;
        block5: while (!done) {
            int next = this.in.read();
            switch (next) {
                case -1: {
                    result = skipWhitespace ? b.toString().trim() : b.toString();
                    done = true;
                    break;
                }
                case 10: {
                    if (b.length() == 0) {
                        if (skipEmptyLines) continue block5;
                        result = "\r\n";
                        done = true;
                        break;
                    }
                    result = skipWhitespace ? b.toString().trim() : b.toString();
                    done = true;
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    b.append((char)next);
                }
            }
        }
        if (result == null) {
            throw new IOException("unexpected end of stream");
        }
        if (this.wireTraceEnabled && this.WIRE_TRACE_LOCATION.beDebug()) {
            this.WIRE_TRACE_LOCATION.debugT("readLine(boolean,boolean)", result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        skipped = this.skipAvailable(n);
        if (skipped > 0L) ** GOTO lbl8
        return skipped;
        while ((cnt = this.skipAvailable(n)) > 0L) {
            skipped += cnt;
lbl8:
            // 2 sources

            if (skipped < n && this.in.available() > 0) continue;
        }
        if (ChunkedInputStream.TRACE.beDebug()) {
            ChunkedInputStream.TRACE.debugT("skip(long)", "{0} bytes skipped", new Object[]{Long.toString(skipped)});
        }
        return skipped;
    }

    public void skipContent() throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        if (!this.limited) {
            return;
        }
        while (this.skipAvailable() > 0L) {
        }
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.skipContent();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        try {
            block4: {
                try {
                    if (this.socket == null) break block4;
                    this.socket.shutdownInput();
                }
                catch (Exception ex) {
                    TRACE.catching("shutdown()", (Throwable)ex);
                    Object var3_2 = null;
                    TRACE.debugT("shutdown()", "socket input stream [shutdown]");
                    this.in = null;
                    this.buf = null;
                    return;
                }
            }
            Object var3_1 = null;
            TRACE.debugT("shutdown()", "socket input stream [shutdown]");
            this.in = null;
            this.buf = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TRACE.debugT("shutdown()", "socket input stream [shutdown]");
            this.in = null;
            this.buf = null;
            throw throwable;
        }
    }

    public void release() throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
        this.close();
        this.disableLimit();
        this.enableChunking(false);
        this.disableWireTrace();
    }

    public void enableChunking(boolean enable) {
        this.chunking = enable;
        this.chunkCount = 0;
        this.toRead = -1L;
        this.limited = enable;
    }

    public boolean chunking() {
        return this.chunking;
    }

    public void enableLimit(long limit) {
        this.limit = limit;
        this.toRead = limit;
        this.chunking = false;
        this.limited = true;
    }

    public void disableLimit() {
        this.toRead = -1L;
        this.limited = false;
    }

    public void enableWireTrace() {
        this.wireTraceEnabled = true;
    }

    public void enableWireTrace(Location location) {
        this.wireTraceEnabled = true;
        if (location != null) {
            this.WIRE_TRACE_LOCATION = location;
        }
    }

    public void disableWireTrace() {
        this.wireTraceEnabled = false;
    }

    public boolean isWireTraceEnabled() {
        return this.wireTraceEnabled;
    }

    private int readChunkLength() throws IOException, NumberFormatException {
        int result = -1;
        String s = this.readLine(true, true);
        int chunkExt = s.indexOf(59);
        result = chunkExt != -1 ? Integer.parseInt(s.substring(0, chunkExt), 16) : Integer.parseInt(s, 16);
        return result;
    }

    private void fill() throws IOException {
        if (this.chunking) {
            this.fillChunked();
        } else {
            this.fillUnchunked();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillChunked() throws IOException {
        this.pos = 0;
        this.count = 0;
        if (this.chunkCount < 0) {
            return;
        }
        if (this.chunkCount == 0) {
            try {
                this.chunkCount = this.readChunkLength();
            }
            catch (NumberFormatException e) {
                TRACE.catching("fillChunked()", (Throwable)e);
                throw new IOException("Malformed chunk size [not a number]");
            }
        }
        if (this.chunkCount > 0) {
            int n = this.chunkCount < this.buf.length ? this.chunkCount : this.buf.length;
            int cnt = this.in.read(this.buf, 0, n);
            if (cnt <= 0) throw new IOException("Unexpected end of chunked body.");
            this.count = cnt;
            this.chunkCount -= cnt;
            if (!this.wireTraceEnabled || !this.WIRE_TRACE_LOCATION.beDebug()) return;
            this.WIRE_TRACE_LOCATION.debugT("fillChunked()", new String(this.buf, 0, cnt));
            return;
        } else {
            this.chunkCount = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillUnchunked() throws IOException {
        this.pos = 0;
        this.count = 0;
        if (this.limited) {
            if (this.toRead <= 0L) {
                return;
            }
            int n = this.toRead < (long)this.buf.length ? (int)this.toRead : this.buf.length;
            int cnt = this.in.read(this.buf, 0, n);
            if (cnt <= 0) throw new IOException("Unexpected end of response. Mismatch between 'Content-Length'header returned by server and actual length of body [retrieved: " + Long.toString(this.limit - this.toRead) + ", expected: " + Long.toString(this.limit) + "]");
            this.count = cnt;
            this.toRead -= (long)cnt;
            if (!this.wireTraceEnabled || !this.WIRE_TRACE_LOCATION.beDebug()) return;
            this.WIRE_TRACE_LOCATION.debugT("fillUnchunked()", new String(this.buf, 0, cnt));
            return;
        } else {
            int cnt = this.in.read(this.buf, 0, this.buf.length);
            if (cnt <= 0) return;
            this.count = cnt;
            if (!this.wireTraceEnabled || !this.WIRE_TRACE_LOCATION.beDebug()) return;
            this.WIRE_TRACE_LOCATION.debugT("fillUnchunked()", new String(this.buf, 0, cnt));
        }
    }

    private int readAvailable(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (!this.limited && len >= this.buf.length) {
                return this.in.read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    private int readAvailable(StringBuffer b, String enc) throws IOException, UnsupportedEncodingException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        b.append(new String(this.buf, 0, avail, enc));
        this.pos += avail;
        return avail;
    }

    private int readAvailable(OutputStream destination) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        destination.write(this.buf, 0, avail);
        this.pos += avail;
        return avail;
    }

    private long skipAvailable() throws IOException {
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return -1L;
            }
        }
        this.pos = (int)((long)this.pos + avail);
        return avail;
    }

    private long skipAvailable(long n) throws IOException {
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return -1L;
            }
        }
        long cnt = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + cnt);
        return cnt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_WIRE_TRACE_LOCATION = TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$streams$ChunkedInputStream == null ? (class$com$tssap$dtr$client$lib$protocol$streams$ChunkedInputStream = ChunkedInputStream.class$("com.tssap.dtr.client.lib.protocol.streams.ChunkedInputStream")) : class$com$tssap$dtr$client$lib$protocol$streams$ChunkedInputStream));
    }
}

