/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.ssl.util;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.ssl.util.ICertificateImport;
import iaik.pkcs.PKCS7CertList;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;

public class PKCS7CertificateImport
implements ICertificateImport {
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$ssl$util$PKCS7CertificateImport == null ? (class$com$tssap$dtr$client$lib$protocol$ssl$util$PKCS7CertificateImport = PKCS7CertificateImport.class$("com.tssap.dtr.client.lib.protocol.ssl.util.PKCS7CertificateImport")) : class$com$tssap$dtr$client$lib$protocol$ssl$util$PKCS7CertificateImport));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$ssl$util$PKCS7CertificateImport;

    public boolean hasClientCertificates() {
        return false;
    }

    public List getClientAliases() {
        return new ArrayList();
    }

    public KeyStore importCertificates(InputStream certStream, String password) throws KeyStoreException, CertificateException {
        PKCS7CertList pkcs7 = null;
        X509Certificate[] certs = null;
        try {
            pkcs7 = new PKCS7CertList(certStream);
            certs = pkcs7.getCertificateList();
        }
        catch (Exception e) {
            throw new CertificateException("Unable to import from PKCS7 stream: " + e.getMessage());
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        }
        catch (NoSuchProviderException e) {
            TRACE.catching("importCertificates(InputStream,String)", (Throwable)e);
            ks = KeyStore.getInstance("JKS");
        }
        try {
            ks.load(null, null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to create keystore: " + e.getMessage());
        }
        int i = 0;
        while (i < certs.length) {
            String principal = certs[i].getSubjectDN().getName();
            ks.setCertificateEntry(principal, (Certificate)certs[i]);
            ++i;
        }
        return ks;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IAIK.addAsJDK14Provider();
    }
}

