/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.ssl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;

public class JSSESecureSocketProvider
implements ISecureSocketProvider {
    private Object JSSE_SOCKET_FACTORY;
    private Method CREATE_SOCKET_METHOD_HOST_PORT;
    private Method CREATE_SOCKET_METHOD_HOST_PORT_SOCKET;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$ssl$JSSESecureSocketProvider == null ? (class$com$tssap$dtr$client$lib$protocol$ssl$JSSESecureSocketProvider = JSSESecureSocketProvider.class$("com.tssap.dtr.client.lib.protocol.ssl.JSSESecureSocketProvider")) : class$com$tssap$dtr$client$lib$protocol$ssl$JSSESecureSocketProvider));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$ssl$JSSESecureSocketProvider;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$Socket;

    private JSSESecureSocketProvider() {
    }

    public static ISecureSocketProvider getDefault() {
        return new JSSESecureSocketProvider();
    }

    public Socket createSocket(String host, int port) throws IOException {
        try {
            if (this.JSSE_SOCKET_FACTORY == null) {
                this.initProvider();
            }
            return (Socket)this.CREATE_SOCKET_METHOD_HOST_PORT.invoke(this.JSSE_SOCKET_FACTORY, host, new Integer(port));
        }
        catch (Exception e) {
            TRACE.catching("createSocket(String,int)", (Throwable)e);
            throw new IOException("failed to create SSL socket [" + e.getMessage() + "]");
        }
    }

    public Socket createSocket(Socket socket, String host, int port) throws IOException {
        try {
            if (this.JSSE_SOCKET_FACTORY == null) {
                this.initProvider();
            }
            return (Socket)this.CREATE_SOCKET_METHOD_HOST_PORT_SOCKET.invoke(this.JSSE_SOCKET_FACTORY, socket, host, new Integer(port));
        }
        catch (Exception e) {
            TRACE.catching("createSocket(Socket,String,int)", (Throwable)e);
            throw new IOException("failed to create SSL socket [" + e.getMessage() + "]");
        }
    }

    public Socket createSocket(String host, int port, String clientAlias) throws IOException {
        return this.createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, String clientAlias) throws IOException {
        return this.createSocket(socket, host, port);
    }

    private void initProvider() throws IOException {
        try {
            Class<?> FACTORY_CLASS = Class.forName("javax.net.ssl.SSLSocketFactory");
            this.JSSE_SOCKET_FACTORY = FACTORY_CLASS.getMethod("getDefault", null).invoke(null, null);
            this.CREATE_SOCKET_METHOD_HOST_PORT = this.JSSE_SOCKET_FACTORY.getClass().getMethod("createSocket", class$java$lang$String == null ? (class$java$lang$String = JSSESecureSocketProvider.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            this.CREATE_SOCKET_METHOD_HOST_PORT_SOCKET = this.JSSE_SOCKET_FACTORY.getClass().getMethod("createSocket", class$java$net$Socket == null ? (class$java$net$Socket = JSSESecureSocketProvider.class$("java.net.Socket")) : class$java$net$Socket, class$java$lang$String == null ? (class$java$lang$String = JSSESecureSocketProvider.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
        }
        catch (Exception e) {
            TRACE.catching("initProvider()", (Throwable)e);
            throw new IOException("failed to initialize JSSE library [" + e.getMessage() + "]");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

