/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.ssl;

import com.sap.security.core.server.https.SecureConnectionFactory;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;

public final class IAIKSecureSocketProvider
implements ISecureSocketProvider {
    private SecureConnectionFactory factory;

    public IAIKSecureSocketProvider(KeyStore trustStore) {
        this.factory = new SecureConnectionFactory(trustStore, null);
        if (trustStore == null) {
            this.factory.setIgnoreServerCertificate(true);
        }
    }

    public IAIKSecureSocketProvider(KeyStore trustAndKeyStore, String password) {
        this.factory = new SecureConnectionFactory(trustAndKeyStore, null, trustAndKeyStore, (Object)(password != null ? password.toCharArray() : null));
        if (trustAndKeyStore == null) {
            this.factory.setIgnoreServerCertificate(true);
        }
    }

    public IAIKSecureSocketProvider(KeyStore trustStore, KeyStore keyStore, String password) {
        this.factory = new SecureConnectionFactory(trustStore, null, keyStore, (Object)(password != null ? password.toCharArray() : null));
        if (trustStore == null) {
            this.factory.setIgnoreServerCertificate(true);
        }
    }

    public IAIKSecureSocketProvider(String trustStore, String keyStore) {
        this.factory = new SecureConnectionFactory(trustStore, keyStore);
        if (trustStore == null) {
            this.factory.setIgnoreServerCertificate(true);
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, String clientAlias) throws IOException {
        if (clientAlias == null) {
            return this.factory.createSocket(host, port);
        }
        return this.factory.createSocket(host, port, new String[]{clientAlias});
    }

    public Socket createSocket(Socket socket, String host, int port) throws IOException {
        return this.factory.createSocket(host, port, socket);
    }

    public Socket createSocket(Socket socket, String host, int port, String clientAlias) throws IOException {
        if (clientAlias == null) {
            return this.factory.createSocket(host, port, socket);
        }
        return this.factory.createSocket(host, port, socket, new String[]{clientAlias});
    }
}

