/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.socks;

import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.socks.ISOCKSProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class SOCKSv5Provider
implements ISOCKSProvider {
    private static final int VER = 5;
    private static final int SUB_VER = 1;
    private static final byte CONNECT = 1;
    private static final byte RSV = 0;
    private static final byte NO_AUTHENTICATION_REQUIRED = 0;
    private static final byte USERNAME_PASSWORD = 2;
    private static final byte NO_ACCEPTABLE_METHODS = -1;
    private static final byte IP_V4 = 1;
    private static final byte DOMAINNAME = 3;
    private static final byte IP_V6 = 4;
    private static final int SUCCEEDED = 0;
    private static final int GENERAL_SOCKS_SERVER_FAILURE = 1;
    private static final int CONNECTION_NOT_ALLOWED = 2;
    private static final int NETWORK_UNREACHABLE = 3;
    private static final int HOST_UNREACHABLE = 4;
    private static final int CONNECTION_REFUSED = 5;
    private static final int TTL_EXPIRED = 6;
    private static final int COMMAND_NOT_SUPPORTED = 7;
    private static final int ADRESS_TYPE_NOT_SUPPORTED = 8;
    private InputStream in;
    private OutputStream out;

    public int getVersion() {
        return 5;
    }

    public Socket getSocket(Socket socket, String host, int port, ISessionContext session) throws SocketException, IOException {
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.connect(host, port, session);
        return socket;
    }

    private void connect(String host, int port, ISessionContext session) throws SocketException, IOException {
        byte[] SAY_HELLO;
        if (session != null && session.getUser() != null && session.getPassword() != null) {
            SAY_HELLO = new byte[4];
            SAY_HELLO[0] = 5;
            SAY_HELLO[1] = 2;
            SAY_HELLO[0] = 0;
            SAY_HELLO[0] = 2;
        } else {
            SAY_HELLO = new byte[3];
            SAY_HELLO[0] = 5;
            SAY_HELLO[1] = 1;
            SAY_HELLO[0] = 0;
        }
        this.out.write(SAY_HELLO);
        this.checkVersion(this.in.read());
        this.authenticate(session);
        byte[] HOST = host.getBytes("ISO-8859-1");
        byte[] SAY_CONNECT = new byte[5 + HOST.length + 2];
        SAY_CONNECT[0] = 5;
        SAY_CONNECT[1] = 1;
        SAY_CONNECT[2] = 0;
        SAY_CONNECT[3] = 3;
        SAY_CONNECT[4] = (byte)HOST.length;
        System.arraycopy(HOST, 0, SAY_CONNECT, 5, HOST.length);
        SAY_CONNECT[5 + HOST.length] = (byte)(port >> 8 & 0xFF);
        SAY_CONNECT[6 + HOST.length] = (byte)(port & 0xFF);
        this.out.write(SAY_CONNECT);
        this.checkVersion(this.in.read());
        this.checkResponseStatus(this.in.read());
        this.in.read();
        this.skipAddress();
    }

    private void checkVersion(int version) throws SocketException {
        if (version != 5) {
            throw new SocketException("Unsupported protocol version: SOCKS v" + version);
        }
    }

    private void checkResponseStatus(int status) throws SocketException {
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                throw new SocketException("General SOCKS server failure.");
            }
            case 2: {
                throw new SocketException("Connecting the SOCKS server is not allowed.");
            }
            case 3: {
                throw new SocketException("The requested network is unreachable.");
            }
            case 4: {
                throw new SocketException("The requested host is unreachable.");
            }
            case 5: {
                throw new SocketException("Connecting the SOCKS server was refused.");
            }
            case 6: {
                throw new SocketException("TTL expired.");
            }
            case 7: {
                throw new SocketException("SOCKS command not supported.");
            }
            case 8: {
                throw new SocketException("Address type not supported.");
            }
            default: {
                throw new SocketException("SOCKS server returnd invalid or unknown status.");
            }
        }
    }

    private void skipAddress() throws SocketException, IOException {
        int addressType = this.in.read();
        int n = 2;
        if (addressType == 1) {
            n += 4;
        } else if (addressType == 4) {
            n += 16;
        } else if (addressType == 3) {
            n += this.in.read();
        } else {
            throw new SocketException("Address type not supported.");
        }
        this.in.skip(n);
    }

    private void authenticate(ISessionContext session) throws SocketException, IOException {
        int method = this.in.read();
        if (method == -1) {
            throw new SocketException("SOCKS server supports no acceptable authentication methods.");
        }
        if (method != 0 && method != 2) {
            throw new SocketException("SOCKS server requires unknown authentication method.");
        }
        if (method == 2) {
            byte[] user = session.getUser().getBytes();
            byte[] password = session.getPassword().getBytes();
            byte[] AUTHENTICATE = new byte[2 + user.length + 1 + password.length];
            AUTHENTICATE[0] = 1;
            AUTHENTICATE[1] = (byte)user.length;
            System.arraycopy(user, 0, AUTHENTICATE, 2, user.length);
            AUTHENTICATE[2 + user.length] = (byte)password.length;
            System.arraycopy(password, 0, AUTHENTICATE, 3 + user.length, password.length);
            this.out.write(AUTHENTICATE);
            int version = this.in.read();
            int status = this.in.read();
            if (version != 1 || status != 0) {
                throw new SocketException("Authentication with SOCKS server failed.");
            }
        }
    }
}

