/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.session;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public final class DigestAuthenticator
implements IAuthenticator {
    private ISessionContext context;
    private final MessageDigest MD5;
    private boolean valid;
    private boolean forProxyAuthentication = false;
    private String realm;
    private String nonce;
    private String domain;
    private String opaque;
    private boolean stale;
    private String algorithm;
    private String qop;
    private int nc;
    private boolean test = false;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$session$DigestAuthenticator == null ? (class$com$tssap$dtr$client$lib$protocol$session$DigestAuthenticator = DigestAuthenticator.class$("com.tssap.dtr.client.lib.protocol.session.DigestAuthenticator")) : class$com$tssap$dtr$client$lib$protocol$session$DigestAuthenticator));
    public static final String AUTH_SCHEME = "Digest";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$session$DigestAuthenticator;

    public DigestAuthenticator(ISessionContext context) {
        this(context, false);
    }

    public DigestAuthenticator(ISessionContext context, boolean forProxyAuthentication) {
        this.context = context;
        try {
            this.MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            TRACE.catching("DigestAuthenticator(ISessionContext,boolean)", (Throwable)ex);
            throw new UnsupportedOperationException("Platform does not support MD5 algorithm");
        }
        this.forProxyAuthentication = forProxyAuthentication;
    }

    public DigestAuthenticator(ISessionContext context, IResponse response) {
        this(context);
        this.setupCredentials(response);
    }

    public DigestAuthenticator(ISessionContext context, DigestAuthenticator auth) {
        this(context);
        this.forProxyAuthentication = auth.forProxyAuthentication();
    }

    public String getAuthenticationScheme() {
        return AUTH_SCHEME;
    }

    public ISessionContext getSessionContext() {
        return this.context;
    }

    public void applyCredentials(URL uri, IRequest request) {
        String header;
        String user = this.forProxyAuthentication ? this.context.getProxyUser() : this.context.getUser();
        String password = this.forProxyAuthentication ? this.context.getProxyPassword() : this.context.getProxyUser();
        String string = header = this.forProxyAuthentication ? "Proxy-Authorization" : "Authorization";
        if (user == null || password == null) {
            TRACE.warningT("applyCredentials(String,IRequest)", "no credentials applied [user or password undefined]");
            return;
        }
        if (!this.valid) {
            TRACE.warningT("applyCredentials(String,IRequest)", "no credentials applied [invalid authentication params]");
            return;
        }
        String path = uri.getPath();
        if (this.domain != null) {
            boolean match = false;
            List uris = Tokenizer.partsOf(this.domain, ",");
            int i = 0;
            while (i < uris.size()) {
                if (path.startsWith((String)uris.get(i))) {
                    match = true;
                    break;
                }
                ++i;
            }
            if (!match) {
                TRACE.warningT("applyCredentials(String,IRequest)", "no credentials applied [no user/password for requested domain]");
                return;
            }
        }
        String nc = this.incrementNC();
        String cnonce = this.test ? "0a4f113b" : this.generateClientNonce();
        byte[] COLON = ":".getBytes();
        this.MD5.reset();
        this.MD5.update(user.getBytes());
        this.MD5.update(COLON);
        this.MD5.update(this.realm.getBytes());
        this.MD5.update(COLON);
        this.MD5.update(password.getBytes());
        byte[] hashA1 = this.MD5.digest();
        if (this.algorithm.equalsIgnoreCase("MD5-SESS")) {
            this.MD5.reset();
            this.MD5.update(hashA1);
            this.MD5.update(COLON);
            this.MD5.update(this.nonce.getBytes());
            this.MD5.update(COLON);
            this.MD5.update(cnonce.getBytes());
            hashA1 = this.MD5.digest();
        }
        byte[] sessionKey = Encoder.encodeHex(hashA1);
        this.MD5.reset();
        this.MD5.update(request.getMethod().getBytes());
        this.MD5.update(COLON);
        this.MD5.update(path.getBytes());
        if (this.qop.equals("auth-int")) {
            String contentMD5 = request.getRequestEntity().getContentMD5();
            if (contentMD5 != null) {
                this.MD5.update(COLON);
                this.MD5.update(contentMD5.getBytes());
            } else {
                this.qop = "auth";
            }
        }
        byte[] hashA2 = this.MD5.digest();
        byte[] hashA2hex = Encoder.encodeHex(hashA2);
        this.MD5.reset();
        this.MD5.update(sessionKey);
        this.MD5.update(COLON);
        this.MD5.update(this.nonce.getBytes());
        this.MD5.update(COLON);
        if (this.qop != null) {
            this.MD5.update(nc.getBytes());
            this.MD5.update(COLON);
            this.MD5.update(cnonce.getBytes());
            this.MD5.update(COLON);
            this.MD5.update(this.qop.getBytes());
            this.MD5.update(COLON);
        }
        this.MD5.update(hashA2hex);
        byte[] responseHash = this.MD5.digest();
        String response = Encoder.toHexString(responseHash);
        StringBuffer buf = new StringBuffer(100);
        buf.append("Digest username=\"").append(user);
        buf.append("\", realm=\"").append(this.realm);
        buf.append("\", nonce=\"").append(this.nonce);
        buf.append("\", uri=\"").append(path).append('\"');
        if (this.qop != null) {
            buf.append(", qop=").append(this.qop).append(", nc=").append(nc);
            buf.append(", cnonce=\"").append(cnonce);
        }
        buf.append("\", response=\"").append(response).append("\"");
        if (this.opaque != null) {
            buf.append(", opaque=\"").append(this.opaque).append("\"");
        }
        request.setHeader(header, buf.toString());
    }

    public void setupCredentials(IResponse response) {
        String auth = null;
        if (response.getStatus() == 401) {
            auth = response.getHeaderValue("WWW-Authenticate");
        } else if (response.getStatus() == 407) {
            auth = response.getHeaderValue("Proxy-Authenticate");
            this.forProxyAuthentication = true;
        }
        if (auth != null && auth.startsWith(AUTH_SCHEME)) {
            this.reset();
            List parts = Tokenizer.partsOf(auth, ",", AUTH_SCHEME.length(), 61);
            Pair p = null;
            int i = 0;
            while (i < parts.size()) {
                p = (Pair)parts.get(i);
                String s = p.getName().toLowerCase();
                if (s.equals("realm")) {
                    this.realm = p.getValue();
                } else if (s.equals("qop")) {
                    this.qop = p.getValue();
                } else if (s.equals("nonce")) {
                    this.nonce = p.getValue();
                } else if (s.equals("opaque")) {
                    this.opaque = p.getValue();
                } else if (s.equals("domain")) {
                    this.domain = p.getValue();
                } else if (s.equals("stale")) {
                    this.stale = p.getValue().equalsIgnoreCase("true");
                } else if (s.equals("algorithm")) {
                    this.algorithm = p.getValue();
                }
                ++i;
            }
            if (this.realm == null || this.nonce == null) {
                TRACE.warningT("setupCredentials(IResponse)", "request for authentication is invalid [missing realm or nonce value in response]");
                return;
            }
            if (this.algorithm != null && !this.algorithm.equalsIgnoreCase("MD5") && !this.algorithm.equalsIgnoreCase("MD5-SESS")) {
                TRACE.warningT("setupCredentials(IResponse)", "request for authentication is invalid [unsupported algorithm '{0}']", new Object[]{this.algorithm});
                return;
            }
            if (this.qop != null) {
                if (this.qop.indexOf("auth") == -1 && this.qop.indexOf("auth-int") == -1) {
                    TRACE.warningT("setupCredentials(IResponse)", "request for authentication is invalid [unsupported qop '{0}']", new Object[]{this.qop});
                    return;
                }
                if (this.qop.indexOf("auth") != -1) {
                    this.qop = "auth";
                }
            }
            if (this.forProxyAuthentication) {
                this.domain = null;
            }
            this.valid = true;
        }
    }

    public void reset() {
        this.valid = false;
        this.realm = null;
        this.nonce = null;
        this.domain = null;
        this.opaque = null;
        this.stale = false;
        this.algorithm = "MD5";
        this.qop = "auth";
        this.nc = 0;
    }

    public boolean forProxyAuthentication() {
        return this.forProxyAuthentication;
    }

    private String generateClientNonce() {
        return String.valueOf(System.currentTimeMillis());
    }

    private String incrementNC() {
        return Encoder.toHexString(++this.nc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

