/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.session;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.Header;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.session.Cookie;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Cookies {
    private Map cookies;
    private Set rejectedDomains;
    private Privacy privacy = Privacy.FROM_ORIGINAL_HOST_ONLY;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$session$Cookies == null ? (class$com$tssap$dtr$client$lib$protocol$session$Cookies = Cookies.class$("com.tssap.dtr.client.lib.protocol.session.Cookies")) : class$com$tssap$dtr$client$lib$protocol$session$Cookies));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$session$Cookies;

    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
        TRACE.infoT("setPrivacy(Privacy)", "cookie privacy setting changed [privacy=\"{0}\"]", new Object[]{privacy.toString()});
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public List getCookies() {
        ArrayList result = new ArrayList();
        if (this.cookies != null) {
            Iterator domains = this.cookies.keySet().iterator();
            while (domains.hasNext()) {
                String domain = (String)domains.next();
                List domainCookies = this.getCookies(domain);
                result.addAll(domainCookies);
            }
        }
        return result;
    }

    public List getCookies(String domain) {
        Object entry;
        if (this.cookies != null && (entry = this.cookies.get(domain)) != null) {
            if (entry instanceof ArrayList) {
                return (List)entry;
            }
            ArrayList singletonList = new ArrayList();
            singletonList.add(entry);
            return singletonList;
        }
        return new ArrayList();
    }

    public List getCookies(String host, String path) {
        return this.getCookies(host, path, -1);
    }

    public List getCookies(String host, String path, int port) {
        List matchingCookies = this.getCookies(Cookie.getDomainOf(host));
        if (matchingCookies.size() > 0) {
            int i = 0;
            while (i < matchingCookies.size()) {
                Cookie cookie = (Cookie)matchingCookies.get(i);
                if (!cookie.matches(host, path, port)) {
                    matchingCookies.remove(i);
                }
                ++i;
            }
            if (matchingCookies.size() > 1) {
                Collections.sort(matchingCookies);
            }
        }
        return matchingCookies;
    }

    public void setCookie(Cookie cookie) {
        List domainCookies;
        if (!cookie.isValid()) {
            if (TRACE.beWarning()) {
                TRACE.warningT("setCookie(Cookie)", "rejecting invalid cookie for domain \"{0}\": {1}", new Object[]{cookie.getDomain(), cookie.getName()});
            }
            return;
        }
        if (this.rejectedDomains != null && this.rejectedDomains.contains(cookie.getDomain())) {
            if (TRACE.beInfo()) {
                TRACE.infoT("setCookie(Cookie)", "rejecting cookie for blocked domain \"{0}\": {1}", new Object[]{cookie.getDomain(), cookie.getName()});
            }
            return;
        }
        boolean accepted = false;
        if (this.cookies == null) {
            this.cookies = new HashMap();
        }
        if ((domainCookies = this.getCookies(cookie.getDomain())) == null) {
            this.cookies.put(cookie.getDomain(), cookie);
            accepted = true;
        } else {
            boolean updated = false;
            int i = 0;
            while (i < domainCookies.size()) {
                if (cookie.equals(domainCookies.get(i))) {
                    updated = true;
                    if (cookie.getMaxAge() == 0L) {
                        domainCookies.remove(i);
                        if (TRACE.beInfo()) {
                            TRACE.infoT("setCookie(Cookie)", "removing expired cookie for domain \"{0}\": {1}", new Object[]{cookie.getDomain(), cookie.getName()});
                        }
                    } else {
                        domainCookies.set(i, cookie);
                        if (TRACE.beInfo()) {
                            TRACE.infoT("setCookie(Cookie)", "updating cookie for domain \"{0}\": {1}", new Object[]{cookie.getDomain(), cookie.getName()});
                        }
                    }
                }
                ++i;
            }
            if (!updated) {
                domainCookies.add(cookie);
                accepted = true;
            }
            this.cookies.put(cookie.getDomain(), domainCookies);
        }
        if (accepted && TRACE.beInfo()) {
            TRACE.infoT("setCookie(Cookie)", "accepting cookie for domain \"{0}\": {1}", new Object[]{cookie.getDomain(), cookie.getName()});
        }
    }

    public void setCookies(List cookies) {
        Iterator iter = cookies.iterator();
        while (iter.hasNext()) {
            Cookie cookie = (Cookie)iter.next();
            this.setCookie(cookie);
        }
    }

    public void removeCookie(Cookie cookie) {
        List domainCookies;
        if (this.cookies != null && (domainCookies = this.getCookies(cookie.getDomain())) != null) {
            int i = 0;
            while (i < domainCookies.size()) {
                if (cookie.equals(domainCookies.get(i))) {
                    domainCookies.remove(i);
                    if (TRACE.beInfo()) {
                        TRACE.infoT("removeCookie(Cookie)", "removing cookie for domain \"{0}\": {1}", new Object[]{cookie.getDomain(), cookie.getName()});
                    }
                }
                ++i;
            }
            this.cookies.put(cookie.getDomain(), domainCookies);
        }
    }

    public void removeCookies(String domain) {
        if (this.cookies != null) {
            this.cookies.remove(domain);
            TRACE.infoT("removeCookies(String)", "removing all cookies for domain \"{0}\"", new Object[]{domain});
        }
    }

    public void removeAll() {
        if (this.cookies != null) {
            this.cookies.clear();
            TRACE.infoT("removeAll()", "removing all cookies");
        }
    }

    public void rejectCookiesFor(String domains) {
        if (this.rejectedDomains == null) {
            this.rejectedDomains = new HashSet();
        }
        List parts = Tokenizer.partsOf(domains, ",;");
        int i = 0;
        while (i < parts.size()) {
            String part = (String)parts.get(i);
            if (!part.startsWith(".")) {
                part = "." + part;
            }
            this.rejectedDomains.add(part);
            ++i;
        }
        TRACE.infoT("rejectCookiesFor(String)", "block cookies for domains \"{0}\"", new Object[]{domains});
    }

    public void allowCookiesFor(String domain) {
        if (this.rejectedDomains != null) {
            this.rejectedDomains.remove(domain);
            TRACE.infoT("allowCookiesFor(String)", "allow cookies for domain \"{0}\"", new Object[]{domain});
        }
    }

    public List rejectedDomains() {
        ArrayList result = new ArrayList();
        if (this.rejectedDomains != null) {
            result.addAll(this.rejectedDomains);
        }
        return result;
    }

    public void applyCookies(IRequest request, IConnection connection) {
        if (this.cookies != null) {
            String path = connection.getAbsolutePath(request.getPath());
            List matchingCookies = this.getCookies(connection.getHost(), path, connection.getPort());
            StringBuffer cookieHeader = new StringBuffer();
            int i = 0;
            while (i < matchingCookies.size()) {
                Cookie cookie = (Cookie)matchingCookies.get(i);
                if (cookie.getExpires() < 0L || cookie.getExpires() > System.currentTimeMillis() || cookie.requiresSecurity() && connection.isSecureProtocol()) {
                    if (i > 0) {
                        cookieHeader.append(',');
                    }
                    cookieHeader.append(cookie.toString());
                }
                ++i;
            }
            if (cookieHeader.length() > 0) {
                request.setHeader("Cookie", cookieHeader.toString());
            }
        }
    }

    public void setupCookies(IResponse response, IConnection connection) {
        Header cookies = response.getHeader("Set-Cookie");
        if (cookies != null) {
            this.setCookies(cookies, response, connection);
        }
        if ((cookies = response.getHeader("Set-Cookie2")) != null) {
            this.setCookies(cookies, response, connection);
        }
    }

    public List searchCookiesByName(String name) {
        Iterator iter = this.getCookies().iterator();
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        while (iter.hasNext()) {
            Cookie next = (Cookie)iter.next();
            if (!name.equals(next.getName())) continue;
            result.add(next);
        }
        return result;
    }

    private void setCookies(Header cookies, IResponse response, IConnection connection) {
        List parts = cookies.getParts();
        int i = 0;
        while (i < parts.size()) {
            Cookie newCookie = new Cookie((String)parts.get(i), connection.getUrl(response.getRequest().getPath()), this.privacy == Privacy.FROM_ALL_HOSTS);
            this.setCookie(newCookie);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Privacy {
        private final String name;
        public static final Privacy FROM_ORIGINAL_HOST_ONLY = new Privacy("from original host only");
        public static final Privacy FROM_ALL_HOSTS = new Privacy("from all hosts");

        private Privacy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

