/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.session;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.ssl.util.PKCS12CertificateImport;
import com.tssap.dtr.client.lib.protocol.ssl.util.PKCS7CertificateImport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;

public class Certificates {
    private KeyStore serverCertificates;
    private KeyStore clientCertificates;
    private String serverCertStore;
    private KeyStoreType serverCertStoreType;
    private String clientCertStore;
    private KeyStoreType clientCertStoreType;
    private String clientStorePwd;
    private String clientKeyPwd;
    private String serverStorePwd;
    private String clientAlias;
    private boolean authenticateMe = false;
    private boolean authenticateThem = true;
    private boolean useEngineStores = false;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$session$Certificates == null ? (class$com$tssap$dtr$client$lib$protocol$session$Certificates = Certificates.class$("com.tssap.dtr.client.lib.protocol.session.Certificates")) : class$com$tssap$dtr$client$lib$protocol$session$Certificates));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$session$Certificates;

    public Certificates() {
    }

    public Certificates(Certificates certificates) {
        this.authenticateMe = certificates.authenticateMe;
        this.authenticateThem = certificates.authenticateThem;
        this.useEngineStores = certificates.useEngineStores;
        this.serverCertStore = certificates.serverCertStore;
        this.serverCertStoreType = certificates.serverCertStoreType;
        this.clientCertStore = certificates.clientCertStore;
        this.clientCertStoreType = certificates.clientCertStoreType;
        this.serverStorePwd = certificates.serverStorePwd;
        this.clientStorePwd = certificates.clientStorePwd;
        this.serverCertificates = certificates.serverCertificates;
        this.clientCertificates = certificates.clientCertificates;
        this.clientKeyPwd = certificates.clientKeyPwd;
    }

    public void setServerCertificates(KeyStore certificates) throws KeyStoreException {
        if (certificates.size() == 0) {
            throw new KeyStoreException("The keystore contains no valid certificates.");
        }
        this.serverCertificates = certificates;
        this.serverCertStoreType = KeyStoreType.typeOf(certificates);
        this.useEngineStores = false;
    }

    public void setServerCertificates(InputStream certStream, String password, KeyStoreType type) throws KeyStoreException {
        try {
            if (type == KeyStoreType.PKCS7) {
                this.setServerCertificates(new PKCS7CertificateImport().importCertificates(certStream, password));
            } else if (type == KeyStoreType.PKCS12) {
                this.setServerCertificates(new PKCS12CertificateImport().importCertificates(certStream, password));
            } else {
                KeyStore keystore = this.createKeyStore(type);
                keystore.load(certStream, password != null ? password.toCharArray() : null);
                this.setServerCertificates(keystore);
                this.serverCertStoreType = type;
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to load keystore: " + e.getMessage());
        }
    }

    public void setServerCertificates(String certFile) {
        String fileName = certFile.toLowerCase();
        KeyStoreType type = null;
        type = fileName.endsWith(".p12") || fileName.endsWith(".pfx") ? KeyStoreType.PKCS12 : (fileName.endsWith(".p7b") ? KeyStoreType.PKCS7 : (fileName.endsWith(".iaik") ? KeyStoreType.IAIK : (fileName.endsWith(".jceks") ? KeyStoreType.JCEKS : KeyStoreType.JKS)));
        this.setServerCertificates(certFile, type);
    }

    public void setServerCertificates(String certFile, KeyStoreType type) {
        this.serverCertStore = certFile;
        this.serverCertStoreType = type;
        this.useEngineStores = false;
    }

    public void setServerCertStorePassword(String password) {
        this.serverStorePwd = password;
    }

    public void setClientCertificates(KeyStore certificates, String keyPassword) throws KeyStoreException {
        if (certificates.size() == 0) {
            throw new KeyStoreException("The keystore contains no valid certificates.");
        }
        this.clientCertificates = certificates;
        this.clientCertStoreType = KeyStoreType.typeOf(certificates);
        this.clientKeyPwd = keyPassword;
        this.useEngineStores = false;
    }

    public void setClientCertificates(InputStream certStream, String password, String keyPassword, KeyStoreType type) throws KeyStoreException {
        try {
            if (type == KeyStoreType.PKCS12) {
                this.setClientCertificates(new PKCS12CertificateImport().importCertificates(certStream, password), keyPassword);
            } else {
                KeyStore keystore = null;
                if (type == KeyStoreType.IAIK) {
                    keystore = KeyStore.getInstance("IAIKKeyStore", "IAIK");
                } else if (type == KeyStoreType.JCEKS) {
                    keystore = KeyStore.getInstance("JCEKS", "SunJCE");
                } else {
                    throw new KeyStoreException("The type " + type.toString() + " does not support safe storage of private keys.");
                }
                keystore.load(certStream, password != null ? password.toCharArray() : null);
                this.setClientCertificates(keystore, keyPassword);
                this.clientCertStoreType = type;
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to load keystore: " + e.getMessage());
        }
    }

    public void setClientCertificates(String certFile) throws KeyStoreException {
        String fileName = certFile.toLowerCase();
        KeyStoreType type = null;
        if (fileName.endsWith(".p12") || fileName.endsWith(".pfx")) {
            type = KeyStoreType.PKCS12;
        } else if (fileName.endsWith(".iaik")) {
            type = KeyStoreType.IAIK;
        } else if (fileName.endsWith(".jceks")) {
            type = KeyStoreType.JCEKS;
        } else {
            throw new KeyStoreException("Unable to determine type of keystore");
        }
        this.setClientCertificates(certFile, type);
    }

    public void setClientCertificates(String certFile, KeyStoreType type) {
        this.clientCertStore = certFile;
        this.clientCertStoreType = type;
    }

    public void setClientAliase(String alias) {
        this.clientAlias = alias;
    }

    public void setEngineCertificateStores(String serverCertStore, String clientCertStore) {
        this.serverCertStore = serverCertStore;
        this.clientCertStore = clientCertStore;
        this.serverCertStoreType = KeyStoreType.SERVER;
        this.clientCertStoreType = KeyStoreType.SERVER;
        this.useEngineStores = true;
    }

    public void setAuthenticateThem(boolean enable) {
        if (!this.useEngineStores) {
            this.authenticateThem = enable;
        }
    }

    public boolean authenticateThem() {
        return this.useEngineStores ? true : this.authenticateThem;
    }

    public void setAuthenticateMe(boolean enable) {
        if (!this.useEngineStores) {
            this.authenticateMe = enable;
        }
    }

    public boolean authenticateMe() {
        return this.useEngineStores ? true : this.authenticateMe;
    }

    public KeyStore getServerCertificates() throws KeyStoreException {
        if (this.useEngineStores) {
            return KeyStore.getInstance("JKS");
        }
        if (this.serverCertificates == null && this.serverCertStore != null) {
            try {
                FileInputStream certStream = new FileInputStream(this.serverCertStore);
                this.setServerCertificates(certStream, this.serverStorePwd, this.serverCertStoreType);
            }
            catch (FileNotFoundException e) {
                throw new KeyStoreException("Server certifcates keystore not found.");
            }
        }
        return this.serverCertificates;
    }

    public KeyStore getClientCertificates() throws KeyStoreException {
        if (this.useEngineStores) {
            return KeyStore.getInstance("JKS");
        }
        if (this.clientCertificates == null && this.clientCertStore != null) {
            try {
                FileInputStream certStream = new FileInputStream(this.clientCertStore);
                this.setClientCertificates(certStream, this.clientStorePwd, this.clientKeyPwd, this.clientCertStoreType);
            }
            catch (FileNotFoundException e) {
                throw new KeyStoreException("Server certifcates keystore not found.");
            }
        }
        return this.clientCertificates;
    }

    public String getServerCertStore() {
        return this.serverCertStore;
    }

    public KeyStoreType getServerCertStoreType() {
        return this.serverCertStoreType;
    }

    public String getClientCertStore() {
        return this.clientCertStore;
    }

    public KeyStoreType getClientCertStoreType() {
        return this.clientCertStoreType;
    }

    public void setClientCertStorePassword(String password) {
        this.clientStorePwd = password;
    }

    public void setClientCertStoreKeyPassword(String password) {
        this.clientKeyPwd = password;
    }

    public String getServerStorePassword() {
        return this.serverStorePwd;
    }

    public String getClientStorePassword() {
        return this.clientStorePwd;
    }

    public String getClientStoreKeyPassword() {
        return this.clientKeyPwd;
    }

    public String getClientAlias() {
        return this.clientAlias;
    }

    public boolean usingEngineKeyStores() {
        return this.useEngineStores;
    }

    public static KeyStore loadDefaultKeystore() {
        return Certificates.loadDefaultKeystore("changeit");
    }

    public static KeyStore loadDefaultKeystore(String password) {
        String filename = System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        if (!new File(filename).exists()) {
            filename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        }
        KeyStore keystore = null;
        try {
            keystore = KeyStore.getInstance("JKS");
            String pwd = password == null ? "changeit" : password;
            keystore.load(new FileInputStream(filename), pwd.toCharArray());
        }
        catch (KeyStoreException e) {
            TRACE.infoT("loadDefaultKeystore(String)", "Unable to instantiate keystore of type 'JKS'.");
            TRACE.catching("loadDefaultKeystore(String)", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            TRACE.infoT("loadDefaultKeystore(String)", "Unable to load keystore: Unknown encryption algoritm.");
            TRACE.catching("loadDefaultKeystore(String)", (Throwable)e);
        }
        catch (CertificateException e) {
            TRACE.infoT("loadDefaultKeystore(String)", "Unable to load keystore: Invalid certificates found.");
            TRACE.catching("loadDefaultKeystore(String)", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TRACE.infoT("loadDefaultKeystore(String)", "Unable to load keystore: The keystore file '{0}' does not exist.", new Object[]{filename});
            TRACE.catching("loadDefaultKeystore(String)", (Throwable)e);
        }
        catch (IOException e) {
            TRACE.infoT("loadDefaultKeystore(String)", "Unable to load keystore: an i/o problem occured.");
            TRACE.catching("loadDefaultKeystore(String)", (Throwable)e);
        }
        return keystore;
    }

    private KeyStore createKeyStore(KeyStoreType type) throws KeyStoreException, NoSuchProviderException {
        KeyStore keystore = null;
        if (type == KeyStoreType.JKS) {
            keystore = KeyStore.getInstance("JKS");
        } else if (type == KeyStoreType.IAIK) {
            keystore = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        } else if (type == KeyStoreType.JCEKS) {
            keystore = KeyStore.getInstance("JCEKS", "SunJCE");
        }
        return keystore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class KeyStoreType {
        private final String name;
        public static final KeyStoreType JKS = new KeyStoreType("JKS");
        public static final KeyStoreType JCEKS = new KeyStoreType("JCEKS");
        public static final KeyStoreType IAIK = new KeyStoreType("IAIK");
        public static final KeyStoreType PKCS7 = new KeyStoreType("PKCS7");
        public static final KeyStoreType PKCS12 = new KeyStoreType("PKCS12");
        public static final KeyStoreType SERVER = new KeyStoreType("SERVER");

        private KeyStoreType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static KeyStoreType valueOf(String type) {
            if (type.equalsIgnoreCase("PKCS7")) {
                return PKCS7;
            }
            if (type.equalsIgnoreCase("PKCS12")) {
                return PKCS12;
            }
            if (type.equalsIgnoreCase("JKS")) {
                return JKS;
            }
            if (type.equalsIgnoreCase("JCEKS")) {
                return JCEKS;
            }
            if (type.equalsIgnoreCase("IAIK")) {
                return IAIK;
            }
            throw new IllegalArgumentException("Invalid keystore type");
        }

        public static KeyStoreType typeOf(KeyStore keystore) {
            String type = keystore.getType();
            if (type.equalsIgnoreCase("jks")) {
                return JKS;
            }
            if (type.equalsIgnoreCase("jceks")) {
                return JCEKS;
            }
            if (type.equalsIgnoreCase("iaikkeystore")) {
                return IAIK;
            }
            return new KeyStoreType(type);
        }
    }
}

