/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseParser;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.IResourceListener;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.streams.PartitionInputStream;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ListCollectionReport
extends RequestBase
implements IResponseParser {
    private static final String ENCODING = "UTF-8";
    private static final int LINEBUF_SIZE = 4096;
    private static final byte[] digits = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private IResourceListener listener;
    private List properties;
    private Map namespaces;
    private List items;
    private Depth depth = Depth.DEPTH_1;
    private boolean propertiesOnly = false;
    private boolean hideDeleted = true;
    private boolean hideFolders = false;
    private boolean ensureFinished = false;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$requests$xcm$ListCollectionReport == null ? (class$com$tssap$dtr$client$lib$protocol$requests$xcm$ListCollectionReport = ListCollectionReport.class$("com.tssap.dtr.client.lib.protocol.requests.xcm.ListCollectionReport")) : class$com$tssap$dtr$client$lib$protocol$requests$xcm$ListCollectionReport));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$requests$xcm$ListCollectionReport;

    public ListCollectionReport(String path, IResourceListener listener) {
        super("REPORT", path);
        this.listener = listener;
        this.setDefaultParser(this);
        this.enableResponseEntityLog(false);
    }

    public void addResource(Item item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(item);
    }

    public void addResources(Item[] items) {
        int i = 0;
        while (i < items.length) {
            this.addResource(items[i]);
            ++i;
        }
    }

    public void addResource(String path) {
        this.addResource(new Item(path));
    }

    public void addResource(String path, long lastSyncedTimestamp) {
        this.addResource(new Item(path, lastSyncedTimestamp));
    }

    public void addResource(String path, Date lastSyncedTimestamp) {
        this.addResource(new Item(path, lastSyncedTimestamp != null ? lastSyncedTimestamp.getTime() : -1L));
    }

    public void addResource(String path, String versionID) {
        this.addResource(new Item(path, versionID));
    }

    public void addResource(String path, int lastSyncedSequenceNumber) {
        this.addResource(new Item(path, lastSyncedSequenceNumber));
    }

    public void addProperty(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        String ns = "DAV:";
        int n = propertyName.indexOf(58);
        if (n > 0 && this.namespaces != null) {
            ns = (String)this.namespaces.get(propertyName.substring(0, n));
        }
        this.properties.add(new Property(propertyName, ns));
    }

    public void addProperty(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(new Property(propertyName, namespaceURI));
    }

    public void addProperties(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.addProperty(propertyNames[i]);
            ++i;
        }
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
            this.addNamespace("XCM:", XCM.NAMESPACE);
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public void setDepth(Depth depth) {
        if (depth.equals(Depth.DEPTH_0)) {
            this.setHeader("Depth", "0");
            this.depth = Depth.DEPTH_0;
        } else if (depth.equals(Depth.DEPTH_1)) {
            this.setHeader("Depth", "1");
            this.depth = Depth.DEPTH_1;
        } else if (depth.equals(Depth.DEPTH_INFINITY)) {
            this.setHeader("Depth", "infinity");
            this.depth = Depth.DEPTH_INFINITY;
        }
    }

    public void showPropertiesOnly() {
        this.propertiesOnly = true;
    }

    public void showDeletedResources() {
        this.hideDeleted = false;
    }

    public void hideFolders() {
        this.hideFolders = true;
    }

    public void ensureFinished() {
        this.ensureFinished = true;
    }

    public IResponseEntity parse(String path, IResponse response) throws HTTPException, IOException {
        ResponseEntityBase entity = null;
        if (response.getStatus() == 200) {
            entity = new ResponseEntityBase(response);
            this.listener.notifyResponse(response);
            IResponseStream in = response.getContent();
            if (in != null) {
                this.parse(in);
            }
        }
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    protected void parse(IResponseStream s) throws HTTPException, IOException {
        int d;
        PartitionInputStream in = new PartitionInputStream(s);
        ResourceElement res = null;
        PropertyElement prop = null;
        int status = -1;
        String description = null;
        int propstat = -1;
        String propstatDescr = null;
        String url = null;
        String value = null;
        byte[] buf = new byte[4096];
        status = 0;
        int c = in.read();
        int n = d = c >= 48 && c < 112 ? digits[c - 48] : -1;
        if (d == -1) {
            status = -1;
        } else {
            status = d;
            while ((c = in.read()) >= 48 && c < 112 && (d = digits[c - 48]) != -1) {
                status *= 10;
                status += d;
            }
        }
        while (status > 0) {
            byte[] newb;
            int next;
            int len = 0;
            int i = 0;
            while ((next = in.read()) != -1) {
                void var16_16;
                if (var16_16 == 10) break;
                if (var16_16 == 13) continue;
                if (len > buf.length) {
                    newb = new byte[len];
                    System.arraycopy(buf, 0, newb, 0, buf.length);
                    buf = newb;
                }
                buf[i++] = (byte)var16_16;
                ++len;
            }
            if (len > 0) {
                description = new String(buf, 0, len, ENCODING);
            }
            len = 0;
            i = 0;
            while ((next = in.read()) != -1) {
                if (next == 10) break;
                if (next == 13) continue;
                if (len > buf.length) {
                    newb = new byte[len];
                    System.arraycopy(buf, 0, newb, 0, buf.length);
                    buf = newb;
                }
                buf[i++] = (byte)next;
                ++len;
            }
            url = new String(buf, 0, len, ENCODING);
            res = new ResourceElement(url);
            res.setStatusCode(status);
            res.setStatusDescription(description);
            if (TRACE.beDebug()) {
                TRACE.debugT("parse(IResponseStream)", "{0} {1}", new Object[]{Integer.toString(status), description});
                TRACE.debugT("parse(IResponseStream)", "{0}", new Object[]{url});
            }
            int propindex = 0;
            len = 0;
            c = in.read();
            int n2 = d = c >= 48 && c < 112 ? digits[c - 48] : -1;
            if (d == -1) {
                len = -1;
            } else {
                len = d;
                while ((c = in.read()) >= 48 && c < 112 && (d = digits[c - 48]) != -1) {
                    len <<= 4;
                    len += d;
                }
            }
            while (len >= 0) {
                int n3;
                boolean noprop = c == 88;
                boolean unknown = noprop && len == 0;
                boolean error = noprop && len > 0;
                propstat = 200;
                propstatDescr = "OK";
                value = null;
                if (len > buf.length) {
                    byte[] newbuf = new byte[len];
                    System.arraycopy(buf, 0, newbuf, 0, buf.length);
                    buf = newbuf;
                }
                if (error) {
                    propstat = 0;
                    c = in.read();
                    int n4 = d = c >= 48 && c < 112 ? digits[c - 48] : -1;
                    if (d == -1) {
                        propstat = -1;
                    } else {
                        propstat = d;
                        while ((c = in.read()) >= 48 && c < 112 && (d = digits[c - 48]) != -1) {
                            propstat *= 10;
                            propstat += d;
                        }
                    }
                    if (len > 4) {
                        int cnt = in.read(buf, 0, len -= 4);
                        while (cnt < len) {
                            n3 = in.read(buf, cnt, len - cnt);
                            cnt += n3;
                        }
                        propstatDescr = new String(buf, 0, len, ENCODING);
                        if (TRACE.beDebug()) {
                            TRACE.debugT("parse(IResponseStream)", "{0}X{1} {2}", new Object[]{Integer.toHexString(len), Integer.toString(propstat), propstatDescr});
                        }
                    } else {
                        propstatDescr = null;
                        if (TRACE.beDebug()) {
                            TRACE.debugT("parse(IResponseStream)", "{0}X{1}", new Object[]{Integer.toHexString(len), Integer.toString(propstat)});
                        }
                    }
                } else if (len > 0) {
                    int cnt = in.read(buf, 0, len);
                    while (cnt < len) {
                        n3 = in.read(buf, cnt, len - cnt);
                        cnt += n3;
                    }
                    value = new String(buf, 0, len, ENCODING);
                    if (TRACE.beDebug()) {
                        TRACE.debugT("parse(IResponseStream)", "{0} {1}", new Object[]{Integer.toHexString(len), value});
                    }
                } else if (unknown) {
                    propstat = 404;
                    propstatDescr = "NOT FOUND";
                    if (TRACE.beDebug()) {
                        TRACE.debugT("parse(IResponseStream)", "{0}X", new Object[]{Integer.toHexString(len)});
                    }
                } else {
                    value = "";
                    if (TRACE.beDebug()) {
                        TRACE.debugT("parse(IResponseStream)", "{0}", new Object[]{Integer.toHexString(len)});
                    }
                }
                if (in.read() == 13) {
                    in.read();
                }
                Property property = (Property)this.properties.get(propindex++);
                prop = new PropertyElement(property.name, property.ns);
                prop.setStatusCode(propstat);
                prop.setStatusDescription(propstatDescr);
                prop.setValue(value);
                res.addChild(prop);
                prop = null;
                len = 0;
                c = in.read();
                int n5 = d = c >= 48 && c < 112 ? digits[c - 48] : -1;
                if (d == -1) {
                    len = -1;
                    continue;
                }
                len = d;
                while ((c = in.read()) >= 48 && c < 112 && (d = digits[c - 48]) != -1) {
                    len <<= 4;
                    len += d;
                }
            }
            if (in.read() == 13) {
                in.read();
            }
            len = 0;
            c = in.read();
            int n6 = d = c >= 48 && c < 112 ? digits[c - 48] : -1;
            if (d == -1) {
                len = -1;
            } else {
                len = d;
                while ((c = in.read()) >= 48 && c < 112 && (d = digits[c - 48]) != -1) {
                    len <<= 4;
                    len += d;
                }
            }
            if (in.read() == 13) {
                in.read();
            }
            if (len > 0) {
                if (TRACE.beDebug()) {
                    TRACE.debugT("parse(IResponseStream)", "Content-Length: {0}", new Object[]{Integer.toHexString(len)});
                }
                in.beginPart(len);
                this.listener.notifyResource(res, in);
                in.endPart(false);
            } else {
                if (TRACE.beDebug()) {
                    TRACE.debugT("parse(IResponseStream)", "Content-Length: 0");
                }
                this.listener.notifyResource(res, null);
            }
            if (in.read() == 13) {
                in.read();
            }
            if (in.read() == 13) {
                in.read();
            }
            status = 0;
            c = in.read();
            int n7 = d = c >= 48 && c < 112 ? digits[c - 48] : -1;
            if (d == -1) {
                status = -1;
                continue;
            }
            status = d;
            while ((c = in.read()) >= 48 && c < 112 && (d = digits[c - 48]) != -1) {
                status *= 10;
                status += d;
            }
        }
    }

    protected IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", ENCODING);
        body.append("<?xml version=\"1.0\" encoding=\"").append(ENCODING).append("\"?>");
        body.append("<").append("XCM:").append("list-collection");
        body.append(" xmlns=\"DAV:\"");
        if (this.namespaces != null && this.namespaces.size() > 0) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        body.append(">");
        if (this.properties != null && this.properties.size() > 0) {
            body.append("<").append("XCM:").append("select><prop>");
            int i = 0;
            while (i < this.properties.size()) {
                body.append("<").append(((Property)this.properties.get((int)i)).name).append("/>");
                ++i;
            }
            body.append("</prop></").append("XCM:").append("select>");
            if (this.propertiesOnly || this.hideDeleted || this.hideFolders || this.ensureFinished) {
                body.append("<").append("XCM:").append("return>");
                if (this.propertiesOnly) {
                    body.append("<").append("XCM:").append("prop-only/>");
                }
                if (this.hideDeleted) {
                    body.append("<").append("XCM:").append("hide-deleted/>");
                }
                if (this.hideFolders) {
                    body.append("<").append("XCM:").append("hide-folders/>");
                }
                if (this.ensureFinished) {
                    body.append("<").append("XCM:").append("end-marker/>");
                }
                body.append("</").append("XCM:").append("return>");
            }
        }
        body.append("<").append("XCM:").append("for>");
        if (this.items == null) {
            body.append("<href>").append(this.getPath()).append("</href>");
        } else {
            Iterator iter = this.items.iterator();
            while (iter.hasNext()) {
                Item item = (Item)iter.next();
                body.append("<").append("XCM:").append("item>");
                body.append("<href>").append(item.path).append("</href>");
                if (item.lastSyncedTimestamp > 0L) {
                    body.append("<").append("XCM:").append("timestamp>");
                    body.append(Long.toString(item.lastSyncedTimestamp));
                    body.append("</").append("XCM:").append("timestamp>");
                } else if (item.versionID != null) {
                    body.append("<").append("XCM:").append("version-id>");
                    body.append(item.versionID);
                    body.append("</").append("XCM:").append("version-id>");
                } else if (item.lastSyncedSequenceNumber > 0) {
                    body.append("<").append("XCM:").append("isn>");
                    body.append(Integer.toString(item.lastSyncedSequenceNumber));
                    body.append("</").append("XCM:").append("isn>");
                }
                if (item.syncToTimestamp > 0L) {
                    body.append("<").append("XCM:").append("sync-to-timestamp>");
                    body.append(Long.toString(item.syncToTimestamp));
                    body.append("</").append("XCM:").append("sync-to-timestamp>");
                } else if (item.syncToSequenceNumber > 0) {
                    body.append("<").append("XCM:").append("sync-to-isn>");
                    body.append(Integer.toString(item.syncToSequenceNumber));
                    body.append("</").append("XCM:").append("sync-to-isn>");
                }
                if (item.pathPattern != null && item.pathPattern.length() > 0) {
                    body.append("<").append("XCM:").append("path-pattern>");
                    body.append(Encoder.encodeXml(item.pathPattern));
                    body.append("</").append("XCM:").append("path-pattern>");
                }
                if (item.namePattern != null && item.namePattern.length() > 0) {
                    body.append("<").append("XCM:").append("name-pattern>");
                    body.append(Encoder.encodeXml(item.namePattern));
                    body.append("</").append("XCM:").append("name-pattern>");
                }
                body.append("</").append("XCM:").append("item>");
            }
        }
        body.append("</").append("XCM:").append("for>");
        body.append("</").append("XCM:").append("list-collection>");
        this.setRequestEntity(body);
        return body;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Item {
        String path;
        String versionID;
        int lastSyncedSequenceNumber = -1;
        int syncToSequenceNumber = -1;
        long lastSyncedTimestamp = -1L;
        long syncToTimestamp = -1L;
        String pathPattern;
        String namePattern;

        public Item(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null");
            }
            this.path = path;
        }

        public Item(String path, long lastSyncedTimestamp) {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null");
            }
            this.path = path;
            this.lastSyncedTimestamp = lastSyncedTimestamp;
        }

        public Item(String path, long lastSyncedTimestamp, long syncTo) {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null");
            }
            this.path = path;
            this.lastSyncedTimestamp = lastSyncedTimestamp;
            this.syncToTimestamp = syncTo;
        }

        public Item(String path, int lastSyncedSequenceNumber) {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null");
            }
            this.path = path;
            this.lastSyncedSequenceNumber = lastSyncedSequenceNumber;
        }

        public Item(String path, int lastSyncedSequenceNumber, int syncTo) {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null");
            }
            this.path = path;
            this.lastSyncedSequenceNumber = lastSyncedSequenceNumber;
            this.syncToSequenceNumber = syncTo;
        }

        public Item(String path, String versionID) {
            if (path == null) {
                throw new IllegalArgumentException("Path must not be null");
            }
            if (versionID == null) {
                throw new IllegalArgumentException("Version ID must not be null");
            }
            this.path = path;
            this.versionID = versionID;
        }

        public void addPattern(String pathPattern, String namePattern) {
            this.pathPattern = pathPattern;
            this.namePattern = namePattern;
        }
    }

    private static class Property {
        public String name;
        public String ns;

        public Property(String name, String ns) {
            this.name = name;
            this.ns = ns;
        }
    }
}

