/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class IntegrationReport
extends MultiStatusRequest {
    private ExpandPropertyDef top;
    private ArrayList properties;
    private HashMap namespaces;
    private String workspace;
    private ArrayList activitySet;
    private ArrayList sequenceNumbers;
    private int sequenceNumberFrom = -1;
    private int sequenceNumberTo = -1;
    private String m_ExclusionWorkspace = null;
    private String m_PathFilter = null;
    private boolean m_ActivitiesOnly = false;
    private boolean m_PropListsOnly = false;

    public IntegrationReport(String path, String workspace) {
        super("REPORT", path);
        this.workspace = workspace;
        this.top = new ExpandPropertyDef("");
        this.addNamespace("XCM:", XCM.NAMESPACE);
    }

    public void addSelectProperty(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
    }

    public void addSelectProperty(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addSelectProperty(propertyName);
    }

    public void addSelectProperty(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, String namespaceURI, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName, namespaceURI);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public void addPropertyExpand(ExpandPropertyDef property, ExpandPropertyDef parent) {
        if (parent != null) {
            parent.addChild(property);
        } else {
            this.top.addChild(property);
        }
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public void addActivityQuery(String activity) {
        if (this.activitySet == null) {
            this.activitySet = new ArrayList();
        }
        this.activitySet.add(activity);
        if (this.sequenceNumbers != null) {
            this.sequenceNumbers.clear();
            this.sequenceNumbers = null;
        }
        this.sequenceNumberFrom = -1;
        this.sequenceNumberTo = -1;
    }

    public void addActivityQuery(String[] activities) {
        int i = 0;
        while (i < activities.length) {
            this.addActivityQuery(activities[i]);
            ++i;
        }
    }

    public void addSequenceNumberQuery(int sequenceNumber) {
        if (sequenceNumber <= 0) {
            throw new IllegalArgumentException("invalid sequence number: " + sequenceNumber);
        }
        if (this.sequenceNumbers == null) {
            this.sequenceNumbers = new ArrayList();
        }
        this.sequenceNumbers.add(new Integer(sequenceNumber));
        if (this.activitySet != null) {
            this.activitySet.clear();
            this.activitySet = null;
        }
        this.sequenceNumberFrom = -1;
        this.sequenceNumberTo = -1;
    }

    public void addSequenceNumberQuery(int[] sequenceNumber) {
        int i = 0;
        while (i < sequenceNumber.length) {
            this.addSequenceNumberQuery(sequenceNumber[i]);
            ++i;
        }
    }

    public void addSequenceNumberRangeQuery(int from, int to) {
        if (to < from || from <= 0 || to <= 0) {
            throw new IllegalArgumentException("invalid sequence number range: (" + from + "-" + to + ")");
        }
        this.sequenceNumberFrom = from;
        this.sequenceNumberTo = to;
        if (this.sequenceNumbers != null) {
            this.sequenceNumbers.clear();
            this.sequenceNumbers = null;
        }
        if (this.activitySet != null) {
            this.activitySet.clear();
            this.activitySet = null;
        }
    }

    public void setExclusionWorkspace(String workspace) {
        this.m_ExclusionWorkspace = workspace;
    }

    public void setPathFilter(String path) {
        this.m_PathFilter = path;
    }

    public void setPropagationListsOnly(boolean plonly) {
        this.m_PropListsOnly = plonly;
    }

    public void setActivitiesOnly(boolean actonly) {
        this.m_ActivitiesOnly = actonly;
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        Iterator iter;
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<").append("XCM:").append("integration-report");
        body.append(" xmlns=\"DAV:\"");
        if (this.namespaces != null && this.namespaces.size() > 0) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        body.append(">");
        if (this.properties != null || this.top.firstChild != null) {
            body.append("<").append("XCM:").append("select>");
            if (this.properties != null) {
                body.append("<prop>");
                int i = 0;
                while (i < this.properties.size()) {
                    body.append("<").append(this.properties.get(i)).append("/>");
                    ++i;
                }
                body.append("</prop>");
            }
            if (this.top.firstChild != null) {
                ExpandPropertyDef child = this.top.firstChild;
                while (child != null) {
                    this.appendChildren(body, child);
                    child = child.next;
                }
            }
            body.append("</").append("XCM:").append("select>");
        }
        body.append("<").append("XCM:").append("where>");
        body.append("<workspace><href>").append(Encoder.encodeXml(this.workspace)).append("</href></workspace>");
        if (this.activitySet != null) {
            body.append("<activity-set>");
            iter = ((AbstractList)this.activitySet).iterator();
            while (iter.hasNext()) {
                body.append("<href>").append(Encoder.encodeXml((String)iter.next())).append("</href>");
            }
            body.append("</activity-set>");
        } else if (this.sequenceNumbers != null) {
            body.append("<").append("XCM:").append("isn-set>");
            iter = ((AbstractList)this.sequenceNumbers).iterator();
            while (iter.hasNext()) {
                body.append("<").append("XCM:").append("isn>").append(iter.next()).append("</").append("XCM:").append("isn>");
            }
            body.append("</").append("XCM:").append("isn-set>");
        } else if (this.sequenceNumberFrom > 0 && this.sequenceNumberTo > 0) {
            body.append("<").append("XCM:").append("isn-range>");
            body.append("<").append("XCM:").append("from>").append(this.sequenceNumberFrom);
            body.append("</").append("XCM:").append("from>");
            body.append("<").append("XCM:").append("to>").append(this.sequenceNumberTo);
            body.append("</").append("XCM:").append("to>");
            body.append("</").append("XCM:").append("isn-range>");
        } else if (this.sequenceNumberFrom < 0 && this.sequenceNumberTo < 0) {
            body.append("<").append("XCM:").append("isn-range>").append("</").append("XCM:").append("isn-range>");
        }
        if (this.m_ExclusionWorkspace != null) {
            body.append("<").append("XCM:").append("not-integrated-in-ws>").append(Encoder.encodeXml(this.m_ExclusionWorkspace)).append("</").append("XCM:").append("not-integrated-in-ws>");
        }
        if (this.m_PathFilter != null) {
            body.append("<").append("XCM:").append("folder-path>").append(Encoder.encodeXml(this.m_PathFilter)).append("</").append("XCM:").append("folder-path>");
        }
        if (this.m_ActivitiesOnly) {
            body.append("<").append("XCM:").append("activities-only/>");
        } else if (this.m_PropListsOnly) {
            body.append("<").append("XCM:").append("propagation-lists-only/>");
        }
        body.append("</").append("XCM:").append("where>");
        body.append("</").append("XCM:").append("integration-report>");
        this.setRequestEntity(body);
        return body;
    }

    private void appendChildren(StringEntity body, ExpandPropertyDef property) {
        ExpandPropertyDef child;
        body.append("<property name=\"").append(property.name).append("\"");
        if (property.namespaceURI != null) {
            body.append(" namespace=\"").append(property.namespaceURI).append("\"");
        }
        if ((child = property.firstChild) == null) {
            body.append("/>");
        } else {
            body.append(">");
            while (child != null) {
                this.appendChildren(body, child);
                child = child.next;
            }
            body.append("</property>");
        }
    }
}

