/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;

public class ImportRequest
extends XMLRequest {
    private static final String IMPORT_OPTIONS = "import-options";
    private static final String TARGET_LOCATION = "target-location";
    private static final String SEGMENTED_IMPORT = "segmented-import";
    private static final String SEGMENT_VERSIONSET_ID = "segment-versionset-id";
    private static final String SEGMENT_COUNT = "segment-count";
    private static final String SEGMENTS_LENGTH = "segments-length";
    private static final String SEGMENTED_IMPORT_START_KEY = "segmented-import-start";
    private static final String SEGMENTED_IMPORT_COMPLETE_KEY = "segmented-import-complete";

    public ImportRequest(String path, IRequestEntity entity) {
        super("IMPORT", path, entity);
    }

    public String getImportedURL() {
        String url = null;
        MultiStatusEntity entity = (MultiStatusEntity)this.getResponseEntity();
        if (entity != null) {
            url = entity.getResource(0).getPath();
        }
        return url;
    }

    public void setImportOptions(int options) {
        this.removeHeader(IMPORT_OPTIONS);
        this.setHeader(IMPORT_OPTIONS, String.valueOf(options));
    }

    public void setWorkspaceTargetLocation(String workspaceLocation) {
        this.removeHeader(TARGET_LOCATION);
        this.setHeader(TARGET_LOCATION, workspaceLocation);
    }

    public void startSegmentedImport(String versionSetID, String segmentCount, String segmentsLength) {
        this.removeAllSegmentedImportHeaders();
        this.setHeader(SEGMENTED_IMPORT, SEGMENTED_IMPORT_START_KEY);
        this.setHeader(SEGMENT_VERSIONSET_ID, versionSetID);
        this.setHeader(SEGMENT_COUNT, segmentCount);
        this.setHeader(SEGMENTS_LENGTH, segmentsLength);
    }

    public void completeSegmentedImport(String versionSetID, String segmentCount, String segmentsLength) {
        this.removeAllSegmentedImportHeaders();
        this.setHeader(SEGMENTED_IMPORT, SEGMENTED_IMPORT_COMPLETE_KEY);
        this.setHeader(SEGMENT_VERSIONSET_ID, versionSetID);
        this.setHeader(SEGMENT_COUNT, segmentCount);
        this.setHeader(SEGMENTS_LENGTH, segmentsLength);
    }

    private void removeAllSegmentedImportHeaders() {
        this.removeHeader(SEGMENTED_IMPORT);
        this.removeHeader(SEGMENT_VERSIONSET_ID);
        this.removeHeader(SEGMENT_COUNT);
        this.removeHeader(SEGMENTS_LENGTH);
    }
}

