/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ActivityIntersectionReport
extends MultiStatusRequest {
    private String method;
    private String sourceWorkspace;
    private String targetWorkspace;
    private ArrayList activitySet;
    private int maxLevel = -1;

    public ActivityIntersectionReport(String path) {
        super("REPORT", path);
    }

    public void applyToIntegration(String sourceWorkspace, String targetWorkspace) {
        this.method = "integration";
        this.sourceWorkspace = sourceWorkspace;
        this.targetWorkspace = targetWorkspace;
    }

    public void applyToPropagation(String sourceWorkspace) {
        this.method = "propagation";
        this.sourceWorkspace = sourceWorkspace;
    }

    public void addActivity(String activity) {
        if (this.activitySet == null) {
            this.activitySet = new ArrayList();
        }
        this.activitySet.add(activity);
    }

    public void setMaximumLevel(int level) {
        this.maxLevel = level;
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<").append("XCM:").append("activity-intersection-report");
        body.append(" xmlns=\"DAV:\"").append(XCM.PREFIXED_XMLNS).append(">");
        body.append("<").append("XCM:").append(this.method).append(">");
        body.append("<").append("XCM:").append("source-workspace><href>");
        body.append(Encoder.encodeXml(this.sourceWorkspace)).append("</href></");
        body.append("XCM:").append("source-workspace>");
        if (this.method.equals("integration")) {
            body.append("<").append("XCM:").append("target-workspace><href>");
            body.append(Encoder.encodeXml(this.targetWorkspace)).append("</href></");
            body.append("XCM:").append("target-workspace>");
        }
        if (this.activitySet != null) {
            body.append("<activity-set>");
            Iterator iter = ((AbstractList)this.activitySet).iterator();
            while (iter.hasNext()) {
                body.append("<href>").append(Encoder.encodeXml((String)iter.next())).append("</href>");
            }
            body.append("</activity-set>");
        }
        if (this.maxLevel > 0) {
            body.append("<").append("XCM:").append("max-level>").append(this.maxLevel);
            body.append("</").append("XCM:").append("max-level>");
        }
        body.append("</").append("XCM:").append(this.method).append(">");
        body.append("</").append("XCM:").append("activity-intersection-report>");
        this.setRequestEntity(body);
        return body;
    }
}

