/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;
import java.util.Iterator;

public class ActiveVersionsReport
extends MultiStatusRequest {
    private int integrationNumber = -1;
    private ArrayList activitySet;
    private boolean changedOnly;

    public ActiveVersionsReport(String workspacePath) {
        super("REPORT", workspacePath);
    }

    public ActiveVersionsReport(String workspacePath, int integrationNumber) {
        super("REPORT", workspacePath);
        this.integrationNumber = integrationNumber;
    }

    public void selectActivity(String activityID) {
        if (this.activitySet == null) {
            this.activitySet = new ArrayList();
        }
        this.activitySet.add(activityID);
    }

    public void selectActivity(String[] activities) {
        if (this.activitySet == null) {
            this.activitySet = new ArrayList();
        }
        int i = 0;
        while (i < activities.length) {
            this.activitySet.add(activities[i]);
            ++i;
        }
    }

    public void setSequenceNumber(int isn) {
        this.integrationNumber = isn;
    }

    public void applyToChangedVersionsOnly() {
        this.changedOnly = true;
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<").append("XCM:").append("list-active-versions");
        body.append(" xmlns=\"DAV:\"").append(XCM.PREFIXED_XMLNS).append(">");
        if (this.integrationNumber >= 0) {
            body.append("<").append("XCM:").append("isn>").append(this.integrationNumber);
            body.append("</").append("XCM:").append("isn>");
        }
        if (this.activitySet != null) {
            body.append("<").append("XCM:").append("activity-set>");
            int i = 0;
            while (i < this.activitySet.size()) {
                body.append("<href>/nonvresbyid/");
                body.append(Encoder.encodeXml((String)this.activitySet.get(i)));
                body.append("</href>");
                ++i;
            }
            body.append("</").append("XCM:").append("activity-set>");
        }
        if (this.changedOnly) {
            body.append("<").append("XCM:").append("changed-versions-only/>");
        }
        body.append("</").append("XCM:").append("list-active-versions>");
        this.setRequestEntity(body);
        return body;
    }
}

