/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class VersionControlRequest
extends XMLRequest {
    private String version;

    public VersionControlRequest(String path) {
        super("VERSION-CONTROL", path);
    }

    public VersionControlRequest(String path, String version) {
        super("VERSION-CONTROL", path);
        this.version = version;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        if (this.version != null) {
            body = new StringEntity("text/xml", "UTF-8");
            body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
            body.append("<version-control").append(" xmlns=\"DAV:\"").append("><version><href>");
            body.append(Encoder.encodeXml(this.version));
            body.append("</href></version></version-control>");
        }
        this.setRequestEntity(body);
        return body;
    }
}

