/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.MergePreviewEntity;
import com.tssap.dtr.client.lib.protocol.entities.SAXResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Iterator;

public class MergePreviewReport
extends XMLRequest {
    private String source;

    public MergePreviewReport(String path, String source) {
        super("REPORT", path);
        this.source = source;
    }

    public int countResources() {
        MergePreviewEntity entity = MergePreviewEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public Element getResource(int i) {
        MergePreviewEntity entity = MergePreviewEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MergePreviewEntity entity = MergePreviewEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<merge-preview").append(" xmlns=\"DAV:\"").append(">");
        body.append("<source><href>").append(Encoder.encodeXml(this.source)).append("</href></source>");
        body.append("</merge-preview>");
        this.setRequestEntity(body);
        return body;
    }

    protected SAXResponseEntity createResponseEntity(String path, IResponse response) {
        SAXResponseEntity entity = super.createResponseEntity(path, response);
        if (entity == null && response.isContentXML() && response.getStatus() == 200) {
            entity = new MergePreviewEntity(response);
        }
        return entity;
    }
}

