/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import java.util.Iterator;

public class ExpandPropertyReport
extends MultiStatusRequest {
    private ExpandPropertyDef top = new ExpandPropertyDef("");

    public ExpandPropertyReport(String path) {
        super("REPORT", path);
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, String namespaceURI, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName, namespaceURI);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public void addPropertyExpand(ExpandPropertyDef property, ExpandPropertyDef parent) {
        if (parent != null) {
            parent.addChild(property);
        } else {
            this.top.addChild(property);
        }
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<expand-property").append(" xmlns=\"DAV:\"");
        if (this.top.firstChild != null) {
            body.append(">");
            ExpandPropertyDef child = this.top.firstChild;
            while (child != null) {
                this.appendChildren(body, child);
                child = child.next;
            }
            body.append("</expand-property>");
        } else {
            body.append("/>");
        }
        this.setRequestEntity(body);
        return body;
    }

    private void appendChildren(StringEntity body, ExpandPropertyDef property) {
        ExpandPropertyDef child;
        body.append("<property name=\"").append(property.name).append("\"");
        if (property.namespaceURI != null) {
            body.append(" namespace=\"").append(property.namespaceURI).append("\"");
        }
        if ((child = property.firstChild) == null) {
            body.append("/>");
        } else {
            body.append(">");
            while (child != null) {
                this.appendChildren(body, child);
                child = child.next;
            }
            body.append("</property>");
        }
    }
}

