/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CopyRequest
extends XMLRequest {
    private Depth depth = Depth.DEPTH_INFINITY;
    private boolean overwrite = true;
    private String label;
    private PropertyBehavior propertyBehavior = PropertyBehavior.NONE;
    private ArrayList properties;
    private HashMap namespaces;

    public CopyRequest(String path, String destination) {
        super("COPY", path);
        this.setHeader("Destination", destination);
    }

    public CopyRequest(String path, String destination, Depth depth) {
        super("COPY", path);
        this.setHeader("Destination", destination);
        this.setDepth(depth);
    }

    public void setDepth(Depth depth) {
        if (depth.equals(Depth.DEPTH_0)) {
            this.setHeader("Depth", "0");
            this.depth = Depth.DEPTH_0;
        } else if (depth.equals(Depth.DEPTH_INFINITY)) {
            this.setHeader("Depth", "infinity");
            this.depth = Depth.DEPTH_INFINITY;
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        this.setHeader("Overwrite", overwrite ? "T" : "F");
    }

    public void setPropertyBehavior(PropertyBehavior propertyBehavior) {
        this.propertyBehavior = propertyBehavior;
    }

    public void addKeepAliveProperty(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
        this.setPropertyBehavior(PropertyBehavior.KEEP_ALIVE);
    }

    public void addKeepAliveProperty(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addKeepAliveProperty(propertyName);
        this.setPropertyBehavior(PropertyBehavior.KEEP_ALIVE);
    }

    public void addKeepAliveProperty(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
        this.setPropertyBehavior(PropertyBehavior.KEEP_ALIVE);
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public void setApplyToLabel(String label) {
        this.label = label;
        if (label != null) {
            this.setHeader("Label", label);
        }
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        if (!this.propertyBehavior.equals(PropertyBehavior.NONE)) {
            body = new StringEntity("text/xml", "UTF-8");
            body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
            body.append("<propertybehavior").append(" xmlns=\"DAV:\"");
            if (this.properties != null && this.namespaces != null && this.namespaces.size() > 0) {
                Iterator keys = this.namespaces.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
                }
            }
            body.append(">");
            if (this.propertyBehavior.equals(PropertyBehavior.OMIT)) {
                body.append("<omit/>");
            } else if (this.propertyBehavior.equals(PropertyBehavior.KEEP_ALIVE)) {
                body.append("<keepalive>");
                if (this.properties == null) {
                    body.append("*");
                } else {
                    int i = 0;
                    while (i < this.properties.size()) {
                        body.append("<href>").append((String)this.properties.get(i)).append("</href>");
                        ++i;
                    }
                }
                body.append("</keepalive>");
            }
            body.append("</propertybehavior>");
        }
        this.setRequestEntity(body);
        return body;
    }
}

