/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dasl;

import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class Query {
    private String op;
    private String value;
    private String ns;
    private String nsprefix;
    private Query firstChild;
    private Query next;

    private Query() {
    }

    private Query(String op) {
        this.op = op;
    }

    private Query(String op, String value) {
        this.op = op;
        this.value = value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        this.serialize(s);
        return s.toString();
    }

    public static Query contains(String literal) {
        return new Query("contains", literal);
    }

    public static Query isCollection() {
        return new Query("is-collection");
    }

    public static Query isDefined(String propertyName) {
        return Query.isDefined(propertyName, null);
    }

    public static Query isDefined(String propertyName, String namespaceURI) {
        Query q = new Query("isdefined");
        Query prop = q.addChild("prop", null).addChild(propertyName, null);
        int n = propertyName.indexOf(58);
        if (n > 0) {
            prop.nsprefix = propertyName.substring(0, n);
        }
        prop.ns = namespaceURI;
        return q;
    }

    public static Query lower(String propertyName, String literal) {
        return Query.relationalOperator("lt", propertyName, literal);
    }

    public static Query lower(String propertyName, String namespaceURI, String literal) {
        return Query.relationalOperator("lt", propertyName, namespaceURI, literal);
    }

    public static Query lowerEqual(String propertyName, String literal) {
        return Query.relationalOperator("lte", propertyName, literal);
    }

    public static Query lowerEqual(String propertyName, String namespaceURI, String literal) {
        return Query.relationalOperator("lte", propertyName, namespaceURI, literal);
    }

    public static Query greater(String propertyName, String literal) {
        return Query.relationalOperator("gt", propertyName, literal);
    }

    public static Query greater(String propertyName, String namespaceURI, String literal) {
        return Query.relationalOperator("gt", propertyName, namespaceURI, literal);
    }

    public static Query greaterEqual(String propertyName, String literal) {
        return Query.relationalOperator("gte", propertyName, literal);
    }

    public static Query greaterEqual(String propertyName, String namespaceURI, String literal) {
        return Query.relationalOperator("gte", propertyName, namespaceURI, literal);
    }

    public static Query equal(String propertyName, String literal) {
        return Query.relationalOperator("eq", propertyName, literal);
    }

    public static Query equal(String propertyName, String namespaceURI, String literal) {
        return Query.relationalOperator("eq", propertyName, namespaceURI, literal);
    }

    public static Query like(String propertyName, String literal) {
        return Query.relationalOperator("like", propertyName, literal);
    }

    public static Query like(String propertyName, String namespaceURI, String literal) {
        return Query.relationalOperator("like", propertyName, namespaceURI, literal);
    }

    public static Query and(Query left, Query right) {
        return Query.logicalOperator("and", left, right);
    }

    public static Query or(Query left, Query right) {
        return Query.logicalOperator("or", left, right);
    }

    public static Query not(Query left) {
        Query q = new Query("not");
        q.addChild(left);
        return q;
    }

    public static Query relationalOperator(String op, String propertyName, String literal) {
        return Query.relationalOperator(op, propertyName, null, literal);
    }

    public static Query relationalOperator(String op, String propertyName, String namespaceURI, String literal) {
        Query q = new Query(op);
        Query prop = q.addChild("prop", null).addChild(propertyName, null);
        int n = propertyName.indexOf(58);
        if (n > 0) {
            prop.nsprefix = propertyName.substring(0, n);
        }
        prop.ns = namespaceURI;
        q.addChild("literal", literal);
        return q;
    }

    public static Query logicalOperator(String op, Query left, Query right) {
        Query q = new Query(op);
        q.addChild(left);
        q.addChild(right);
        return q;
    }

    private Query addChild(Query query) {
        Query child = this.firstChild;
        if (child != null) {
            while (child.next != null) {
                child = child.next;
            }
            child.next = query;
        } else {
            this.firstChild = query;
        }
        return query;
    }

    private Query addChild(String name, String value) {
        Query child = this.firstChild;
        Query newChild = new Query(name, value);
        if (child != null) {
            while (child.next != null) {
                child = child.next;
            }
            child.next = newChild;
        } else {
            this.firstChild = newChild;
        }
        return newChild;
    }

    void serialize(StringBuffer buf) {
        buf.append("<").append(this.op);
        if (this.ns != null) {
            buf.append(" xmlns:").append(this.nsprefix).append("=\"").append(this.ns).append("\"");
        }
        if (this.firstChild == null && this.value == null) {
            buf.append("/>");
            return;
        }
        buf.append(">");
        if (this.value != null) {
            buf.append(Encoder.encodeXml(this.value));
        } else {
            Query child = this.firstChild;
            while (child != null) {
                child.serialize(buf);
                child = child.next;
            }
        }
        buf.append("</").append(this.op).append(">");
    }

    public static class LogicalOperators {
        public static final String AND = "and";
        public static final String OR = "or";
    }

    public static class PropertyOperators {
        public static final String EQUAL = "eq";
        public static final String LOWER = "lt";
        public static final String LOWER_OR_EQUAL = "lte";
        public static final String GREATER = "gt";
        public static final String GREATER_OR_EQUAL = "gte";
        public static final String LIKE = "like";
    }
}

