/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseParser;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.SAXResponseEntity;
import com.tssap.dtr.client.lib.protocol.requests.ParserException;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLRequest
extends RequestBase
implements IResponseParser {
    public static final String ENCODING = "utf-8";
    private XMLReader saxParser;

    public XMLRequest(String method, String path) {
        super(method, path);
        this.setDefaultParser(this);
    }

    public XMLRequest(String method, String path, IRequestEntity entity) {
        super(method, path, entity);
        this.setDefaultParser(this);
    }

    public void clear() {
        super.clear();
        this.setDefaultParser(this);
    }

    public IResponseEntity parse(String path, IResponse response) throws HTTPException {
        SAXResponseEntity entity = this.createResponseEntity(path, response);
        if (entity != null) {
            try {
                XMLReader parser = this.createXMLReader();
                if (parser != null) {
                    parser.setContentHandler(entity);
                    InputSource s = new InputSource(response.getStream());
                    parser.parse(s);
                }
            }
            catch (Exception ex) {
                throw new HTTPException("Parsing of the response body failed", ex);
            }
        }
        return entity;
    }

    protected SAXResponseEntity createResponseEntity(String path, IResponse response) {
        SAXResponseEntity entity = null;
        if (response.isContentXML()) {
            int responseStatus = response.getStatus();
            if (responseStatus >= 400 && responseStatus < 500) {
                entity = new ErrorEntity(response);
            } else if (responseStatus == 207) {
                entity = new MultiStatusEntity(path, response);
            }
        }
        return entity;
    }

    private XMLReader createXMLReader() {
        if (this.saxParser == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this.saxParser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                    this.saxParser.setFeature("http://xml.org/sax/features/namespaces", true);
                }
                catch (SAXNotRecognizedException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Selected XML parser does not support namespace handling", ex);
                }
                catch (SAXNotSupportedException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Selected XML parser does not support namespace handling", ex);
                }
                catch (SAXException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Unable to find or instantiate XML parser", ex);
                }
                catch (FactoryConfigurationError ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Failed to instantiate XML parser factory", ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Unable to find or instantiate XML parser", ex);
                }
                Object var8_2 = null;
                Thread.currentThread().setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var8_3 = null;
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
        }
        return this.saxParser;
    }
}

