/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.multipart;

import com.tssap.dtr.client.lib.protocol.Header;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.multipart.IRequestPart;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RequestPart
implements IRequestPart {
    private static final String CRLF = "\r\n";
    private Map headers;
    private IRequestEntity entity;
    private String contentType;
    private String contentID;
    private long contentLength = -1L;
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_DESCRIPTOR = "Content-Descriptor";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_ID = "Content-ID";

    public RequestPart(String contentID, IRequestEntity entity) {
        this.entity = entity;
        this.contentID = contentID;
        this.contentLength = entity.getContentLength();
        if (this.contentLength > 0L) {
            this.setHeader("Content-Length", Long.toString(this.contentLength));
        }
        this.contentType = entity.getContentType();
        if (this.contentType == null) {
            this.contentType = "application/octet-stream";
        }
        this.setHeader("Content-Type", this.contentType);
        if (entity.getContentMD5() != null) {
            this.setHeader("Content-MD5", entity.getContentMD5());
        }
        this.setHeader(CONTENT_ID, contentID);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentID() {
        return this.contentID;
    }

    public IRequestEntity getEntity() {
        return this.entity;
    }

    public Iterator getHeaderNames() {
        if (this.headers == null) {
            return null;
        }
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = RequestPart.this.headers.keySet().iterator();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                Header header = (Header)RequestPart.this.headers.get(this.iter.next());
                if (header != null) {
                    return header.getName();
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Header getHeader(String name) {
        if (this.headers == null || name == null || name.length() == 0) {
            return null;
        }
        return (Header)this.headers.get(name.toLowerCase());
    }

    public String getHeaderValue(String name) {
        if (this.headers == null || name == null || name.length() == 0) {
            return null;
        }
        Header header = (Header)this.headers.get(name.toLowerCase());
        return header != null ? header.getValue() : null;
    }

    public String getHeaderValue(String name, String defaultValue) {
        String value = this.getHeaderValue(name);
        return value != null ? value : defaultValue;
    }

    public void setHeader(Header header) {
        String name = header.getName();
        if (name != null && name.length() > 0) {
            if (this.headers == null) {
                this.headers = new HashMap();
            }
            this.headers.put(name.toLowerCase(), header);
        }
    }

    public void setHeader(Header header, boolean append) {
        String name = header.getName();
        if (name != null && name.length() > 0) {
            if (!append || this.headers == null) {
                this.setHeader(header);
            } else {
                Header existingHeader = (Header)this.headers.get(name.toLowerCase());
                if (existingHeader == null) {
                    this.setHeader(header);
                } else {
                    existingHeader.appendPart(header.getValue(), ", ");
                }
            }
        }
    }

    public void setHeader(String name, String value) {
        if (name != null || name.length() > 0) {
            this.setHeader(new Header(name, value));
        }
    }

    public void setHeader(String name, String value, boolean append) {
        if (name != null || name.length() > 0) {
            this.setHeader(new Header(name, value), append);
        }
    }

    public void setHeaders(Header[] headerList) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        int i = 0;
        while (i < headerList.length) {
            this.setHeader(headerList[i]);
            ++i;
        }
    }

    public void removeHeader(String name) {
        if (name != null && name.length() > 0 && this.headers != null) {
            this.headers.remove(name.toLowerCase());
        }
    }

    public void removeAllHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    void appendHeader(StringBuffer sb) {
        Iterator iter = this.getHeaderNames();
        if (iter != null) {
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = this.getHeaderValue(name);
                if (value == null || value.length() <= 0) continue;
                sb.append(name).append(": ").append(value).append(CRLF);
            }
        }
    }
}

