/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.Header;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.streams.ResponseStream;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;

public class Response
implements IResponse {
    private String version;
    private boolean usingHTTP10 = false;
    private int status = -1;
    private String description;
    private String statusLine;
    private HashMap headers;
    private String contentType;
    private long contentLength = -1L;
    private boolean contentChunked = false;
    private ResponseStream content;
    private boolean digestEnabled = false;
    private String digestAlgorithm = null;
    private byte[] digest;
    private IRequest request;
    private boolean secureProtocol;
    private IResponseEntity entity;
    private long duration;
    private boolean closingConnection;
    private static final boolean APPEND_TO_EXISTING_HEADER = true;
    private static final boolean SKIP_WHITESPACE = true;
    private static final boolean REPORT_WHITESPACE = false;
    private static final boolean SKIP_EMPTY_LINES = true;
    private static final boolean REPORT_EMPTY_LINES = false;
    private static final String END_OF_LINE = "\r\n";
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$impl$Response == null ? (class$com$tssap$dtr$client$lib$protocol$impl$Response = Response.class$("com.tssap.dtr.client.lib.protocol.impl.Response")) : class$com$tssap$dtr$client$lib$protocol$impl$Response));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$impl$Response;

    public Response(IRequest request) {
        this.request = request;
    }

    public Response(IRequest request, boolean secureProtocol) {
        this.request = request;
        this.secureProtocol = secureProtocol;
    }

    public boolean isValid() {
        return this.status >= 200 && this.status < 600 && this.version != null;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusDescription() {
        return this.description;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public long getDuration() {
        return this.duration;
    }

    public Header getHeader(String name) {
        if (this.headers == null || name == null || name.length() == 0) {
            return null;
        }
        return (Header)this.headers.get(name.toLowerCase());
    }

    public String getHeaderValue(String name) {
        if (this.headers == null || name == null || name.length() == 0) {
            return null;
        }
        Header header = (Header)this.headers.get(name.toLowerCase());
        return header != null ? header.getValue() : null;
    }

    public String getHeaderValue(String name, String defaultValue) {
        String value = this.getHeaderValue(name);
        return value != null ? value : defaultValue;
    }

    public Iterator getHeaderNames() {
        if (this.headers == null) {
            return null;
        }
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = Response.this.headers.keySet().iterator();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                Header header = (Header)Response.this.headers.get(this.iter.next());
                if (header != null) {
                    return header.getName();
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getHTTPVersion() {
        return this.version;
    }

    public boolean getUsingHTTP10() {
        return this.usingHTTP10;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMimeType() {
        return this.entity != null ? this.entity.getMimeType() : null;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public IResponseStream getContent() {
        return this.content;
    }

    public InputStream getStream() {
        return this.content;
    }

    public boolean hasContent() {
        return this.content != null && (this.contentLength != 0L || this.contentChunked);
    }

    public boolean isContentXML() {
        return this.hasContent() && this.contentType != null && (this.contentType.startsWith("text/xml") || this.contentType.startsWith("application/xml"));
    }

    public IRequest getRequest() {
        return this.request;
    }

    public IResponseEntity getEntity() {
        return this.entity;
    }

    public void setEntity(IResponseEntity entity) {
        this.entity = entity;
    }

    public String getEntityType() {
        return this.entity != null ? this.entity.getEntityType() : null;
    }

    public boolean isMultiStatus() {
        return this.status == 207 && MultiStatusEntity.isMultiStatusEntity(this.entity);
    }

    public void skipContent() throws IOException {
        if (this.content != null) {
            this.content.skipContent();
        }
    }

    public void releaseStream() throws IOException {
        if (this.content != null) {
            this.content.release();
            this.readTrailers();
            this.content = null;
        }
    }

    public boolean closingConnection() {
        return this.closingConnection;
    }

    public void enableDigest(String algorithm) {
        this.digestEnabled = true;
        this.digestAlgorithm = algorithm;
    }

    public void initialize(ResponseStream source) throws IOException, HTTPException {
        if (source == null) {
            IOException ex = new IOException("invalid response stream");
            TRACE.throwing("initialize(ResponseStream)", (Throwable)ex);
            throw ex;
        }
        TRACE.debugT("initialize(ResponseStream)", " ");
        String line = null;
        do {
            if ((line = source.readLine(true, true)).length() == 0) {
                throw new SocketException("Socket output stream shutdown by peer.");
            }
            if (!line.startsWith("HTTP/")) {
                throw new HTTPException("Invalid begin of response [expected: 'HTTP', found: '" + line + "']");
            }
            if (TRACE.beDebug()) {
                TRACE.debugT("initialize(ResponseStream)", line);
            }
            this.statusLine = line;
            Tokenizer tokenizer = new Tokenizer(line);
            this.version = tokenizer.nextToken();
            if (this.version.equals("HTTP/1.1")) {
                this.usingHTTP10 = false;
            } else if (this.version.equals("HTTP/1.0")) {
                this.usingHTTP10 = true;
                this.closingConnection = true;
            } else {
                throw new HTTPException("Invalid or unsupported HTTP version [version=" + this.version + "]");
            }
            try {
                this.status = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException e) {
                TRACE.catching("initialize(ResponseStream)", (Throwable)e);
                throw new HTTPException("Invalid HTTP status code [not a number]");
            }
            this.description = tokenizer.lastToken();
            Header currentHeader = null;
            line = source.readLine(false, false);
            while (line != null && !line.equals(END_OF_LINE)) {
                if (Character.isWhitespace(line.charAt(0)) && currentHeader != null) {
                    currentHeader.appendPart(line.trim(), " ");
                } else {
                    currentHeader = new Header(line);
                    this.setHeader(currentHeader, true);
                }
                TRACE.debugT("initialize(ResponseStream)", line);
                line = source.readLine(false, false);
            }
            TRACE.debugT("initialize(ResponseStream)", " ");
        } while (this.status == 100 || this.status == 102);
        if (this.status == 101) {
            return;
        }
        String transferEncodingHeader = this.getHeaderValue("Transfer-Encoding");
        boolean bl = this.contentChunked = transferEncodingHeader != null && transferEncodingHeader.indexOf("chunked") >= 0;
        if (this.contentChunked) {
            this.removeHeader("Content-Length");
        }
        String length = this.getHeaderValue("Content-Length");
        try {
            this.contentLength = length != null ? Long.parseLong(length) : -1L;
        }
        catch (NumberFormatException e) {
            TRACE.catching("initialize(ResponseStream)", (Throwable)e);
            throw new HTTPException("Malformed Content-Length header [not a number]");
        }
        this.contentType = this.getHeaderValue("Content-Type");
        String connectionHeader = this.getHeaderValue("Connection");
        if (connectionHeader != null) {
            connectionHeader = connectionHeader.toLowerCase();
            if (this.usingHTTP10) {
                this.closingConnection = connectionHeader.indexOf("keep-alive") < 0;
            } else {
                boolean bl2 = this.closingConnection = connectionHeader.indexOf("close") >= 0;
            }
        }
        if (this.status == 204 || this.status == 304 || "HEAD".equalsIgnoreCase(this.request.getMethod())) {
            this.content = source;
            this.releaseStream();
            return;
        }
        if (this.contentLength == -1L) {
            if (this.contentType == null) {
                if (this.contentChunked) {
                    this.contentType = this.status == 207 ? "text/xml" : "application/octet-stream";
                    TRACE.infoT("initialize(ResponseStream)", "missing content type [assuming {0}]", new Object[]{this.contentType});
                    this.setHeader("Content-Type", this.contentType);
                }
            } else if (this.usingHTTP10) {
                TRACE.infoT("initialize(ResponseStream)", "missing content length for HTTP/1.0 Keep-Alive connection", new Object[]{this.contentType});
                this.closingConnection = true;
            } else if (!this.contentChunked && !this.closingConnection) {
                TRACE.infoT("initialize(ResponseStream)", "missing content length for non-chunking HTTP/1.1 persistent connection", new Object[]{this.contentType});
                this.closingConnection = true;
            }
        }
        if (this.contentLength != 0L) {
            this.content = source;
            if (this.contentChunked) {
                this.content.enableChunking(this.contentChunked);
            } else if (this.contentLength > 0L) {
                this.content.enableLimit(this.contentLength);
            }
            String contentEncoding = this.getHeaderValue("Content-Encoding");
            if (contentEncoding != null) {
                this.content.setCompressionAlgorithm(contentEncoding.toLowerCase());
                this.content.enableCompression();
            }
            if (this.digestEnabled) {
                this.content.setDigestAlgorithm(this.digestAlgorithm);
                this.content.enableDigest();
            }
            if (this.request.logResponseEntity() && !this.secureProtocol) {
                this.content.enableWireTrace(this.request.getLocation());
            }
        }
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    private void setHeader(String name, String value) {
        if (name != null && name.length() > 0) {
            if (this.headers == null) {
                this.headers = new HashMap();
            }
            this.headers.put(name.toLowerCase(), new Header(name, value));
        }
    }

    private void setHeader(Header header) {
        String name = header.getName();
        if (name != null && name.length() > 0) {
            if (this.headers == null) {
                this.headers = new HashMap();
            }
            this.headers.put(name.toLowerCase(), header);
        }
    }

    private void setHeader(Header header, boolean append) {
        String name = header.getName();
        if (name != null && name.length() > 0) {
            if (!append || this.headers == null) {
                this.setHeader(header);
            } else {
                Header existingHeader = (Header)this.headers.get(name.toLowerCase());
                if (existingHeader == null) {
                    this.setHeader(header);
                } else {
                    existingHeader.appendPart(header.getValue(), ", ");
                }
            }
        }
    }

    private void removeHeader(String name) {
        if (name != null && name.length() > 0 && this.headers != null) {
            this.headers.remove(name.toLowerCase());
        }
    }

    private void readTrailers() throws IOException {
        String line;
        if (this.contentChunked && (line = this.content.readLine(false, true)) != null) {
            boolean skipTrailers = false;
            boolean refreshEntity = false;
            String header = this.request.getHeaderValue("TE");
            if (header == null || header.indexOf("trailers") < 0) {
                skipTrailers = true;
                TRACE.debugT("readTrailers()", "Ignoring unexpected trailers");
            }
            header = this.request.getHeaderValue("Trailer");
            while (line != null && !line.equals(END_OF_LINE)) {
                Header trailer;
                String name;
                if (!(skipTrailers || "Content-Length".equalsIgnoreCase(name = (trailer = new Header(line)).getName()) || "Trailer".equalsIgnoreCase(name) || "Transfer-Encoding".equalsIgnoreCase(name))) {
                    if (header.indexOf(name) < 0) {
                        TRACE.infoT("readTrailers()", "Accepting unexpected trailer: {0}", new Object[]{name});
                    }
                    this.setHeader(trailer, true);
                    refreshEntity = true;
                }
                line = this.content.readLine(false, true);
            }
            if (refreshEntity && this.entity != null) {
                this.entity.initialize(this);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

