/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.impl;

import java.util.NoSuchElementException;

public class HashMapIntInt {
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    protected static final int LAST = -1;
    protected float loadFactor = 0.75f;
    protected int simplIndex = 0;
    protected int limit;
    protected int capacity;
    protected int nextFree;
    protected int[] keys;
    protected int[] elements;
    protected int[] nextPtr;
    protected int count;
    protected static final int[] primes = new int[]{13, 17, 19, 23, 29, 31, 37, 43, 53, 61, 73, 89, 107, 127, 149, 179, 223, 257, 307, 367, 439, 523, 631, 757, 907, 1087, 1301, 1559, 1871, 2243, 2689, 3229, 3877, 4649, 5581, 6689, 8039, 9631, 11579, 13873, 16649, 19973, 23971, 28753, 34511, 41411, 49697, 59621, 71549, 85853, 103043, 123631, 148361, 178021, 213623, 256349, 307627, 369137, 442961, 531569, 637873, 765437, 918529, 1102237, 1322669, 1587221, 1904647, 2285581, 2742689, 3291221, 3949469, 4739363, 5687237, 6824669, 8189603, 9827537, 11793031, 14151629, 16981957, 20378357, 24454013, 29344823, 35213777, 42256531, 50707837, 60849407, 73019327, 87623147, 105147773, 126177323, 151412791, 181695341, 218034407, 261641287, 313969543, 376763459, 452116163, 542539391, 651047261, 781256711, 937508041, 1125009637, 1350011569, 1620013909, 1944016661, Integer.MAX_VALUE};

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public HashMapIntInt() {
        this.init(13);
    }

    public int[] keys() {
        int index = 0;
        int[] result = new int[this.count];
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.keys[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public boolean containsKey(int key) {
        int pos = this.nextPtr[this.hash(key) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity] == key) {
                return true;
            }
            pos = this.nextPtr[pos];
        }
        return false;
    }

    public void clear() {
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public int get(int key) {
        int pos = this.nextPtr[this.hash(key) % this.capacity];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index] == key) {
                return this.elements[index];
            }
            pos = this.nextPtr[pos];
        }
        throw new NoSuchElementException();
    }

    public void put(int key, int value) {
        int index;
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            index = (pos = this.nextPtr[pos]) - this.capacity;
            if (this.keys[index] != key) continue;
            this.elements[index] = value;
            return;
        }
        index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    public void remove(int key) {
        int prevPos = this.hash(key) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            if (this.keys[pos - this.capacity] == key) {
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
    }

    protected void _put(int key, int value) {
        int pos = this.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        int index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    protected void init(int initialCapacity) {
        int n = this.simplIndex < primes.length ? this.simplIndex : primes.length;
        while (primes[n] < initialCapacity) {
            ++n;
        }
        long l = (long)n << 32 | (long)primes[n];
        this.simplIndex = (int)(l >> 32) + 4;
        this.capacity = (int)l;
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new int[this.limit];
        this.elements = new int[this.limit];
        this.nextFree = this.capacity;
        this.count = 0;
    }

    protected long getClosestPrime(int key, int startPos) {
        int i = startPos < primes.length ? startPos : primes.length;
        while (primes[i] < key) {
            ++i;
        }
        return (long)i << 32 | (long)primes[i];
    }

    protected void rehash() {
        int[] oldKeys = this.keys;
        int[] oldElements = this.elements;
        this.init(this.capacity * 2);
        int i = 0;
        while (i < oldKeys.length) {
            this._put(oldKeys[i], oldElements[i]);
            ++i;
        }
    }

    protected int hash(int key) {
        return key & Integer.MAX_VALUE;
    }
}

