/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class StringEntity
implements IRequestEntity {
    private StringBuffer content;
    private long contentLength = -1L;
    private String contentType;
    private String contentMD5;
    private String contentCharset;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$entities$StringEntity == null ? (class$com$tssap$dtr$client$lib$protocol$entities$StringEntity = StringEntity.class$("com.tssap.dtr.client.lib.protocol.entities.StringEntity")) : class$com$tssap$dtr$client$lib$protocol$entities$StringEntity));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$entities$StringEntity;

    public StringEntity(String contentType, String contentCharset) {
        this.contentType = contentType;
        if (contentCharset != null) {
            this.contentType = this.contentType + "; charset=\"" + contentCharset.toLowerCase() + "\"";
        }
        this.contentCharset = contentCharset;
    }

    public StringEntity(String contentType, String contentCharset, String content) {
        this(contentType, contentCharset);
        this.content = new StringBuffer(content);
    }

    public String getEntityType() {
        return "StringEntity";
    }

    public long getContentLength() {
        if (this.content != null) {
            try {
                this.contentLength = Encoder.getBytes(this.content, this.contentCharset).length;
            }
            catch (UnsupportedEncodingException e) {
                TRACE.catching("getContentLength()", (Throwable)e);
                this.contentLength = -1L;
            }
        }
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public String calculateMD5(String enc) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.content != null) {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            MD5.update(Encoder.getBytes(this.content, enc));
            byte[] digest = MD5.digest();
            return Encoder.toHexString(digest);
        }
        return null;
    }

    public String getContent() {
        return this.content.toString();
    }

    public void setContent(String content) {
        if (this.content == null) {
            this.content = new StringBuffer(content);
        } else {
            this.content.setLength(0);
            this.content.append(content);
        }
    }

    public int length() {
        return this.content != null ? this.content.length() : -1;
    }

    public void write(IRequestStream destination) throws IOException {
        if (this.content != null) {
            destination.write(Encoder.getBytes(this.content, this.contentCharset));
        }
    }

    public StringBuffer append(String s) {
        if (this.content == null) {
            this.content = new StringBuffer(s);
        } else {
            this.content.append(s);
        }
        return this.content;
    }

    public void reset() {
    }

    public boolean supportsReset() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringEntity) {
            String a = this.content.toString();
            String b = ((StringEntity)obj).content.toString();
            return a.equals(b);
        }
        if (obj instanceof String) {
            String a = this.content.toString();
            return a.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.content != null ? this.content.toString().hashCode() : super.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

