/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.util.List;

public class ResponseEntityBase
implements IResponseEntity {
    protected long contentLength = -1L;
    protected String contentMD5;
    protected String contentType;
    protected String mimeType;
    protected String contentCharset;
    protected List contentTypeParams;
    protected String lastModified;
    protected String entityTag;

    public ResponseEntityBase(String contentType) {
        this.contentType = contentType;
    }

    public ResponseEntityBase(IResponse response) {
        this.initialize(response);
    }

    public String getEntityType() {
        return "ResponseEntityBase";
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType : "application/octet-stream";
    }

    public List getContentTypeParams() {
        return this.contentTypeParams;
    }

    public String getMimeType() {
        return this.mimeType != null ? this.mimeType : "application/octet-stream";
    }

    public String getEntityTag() {
        return this.entityTag;
    }

    public String getLastModfied() {
        return this.lastModified;
    }

    public void initialize(IResponse response) {
        int n;
        this.contentType = response.getContentType();
        if (this.contentType != null && (n = this.contentType.indexOf(59)) != -1) {
            this.contentTypeParams = Tokenizer.partsOf(this.contentType, ";", n, 61);
            int i = 0;
            while (i < this.contentTypeParams.size()) {
                Pair param = (Pair)this.contentTypeParams.get(i);
                if ("charset".equalsIgnoreCase(param.getValue())) {
                    this.contentCharset = param.getValue();
                }
                ++i;
            }
        }
        this.contentLength = response.getContentLength();
        this.contentMD5 = response.getHeaderValue("Content-MD5");
        this.entityTag = response.getHeaderValue("ETag");
        this.lastModified = response.getHeaderValue("Last-Modfied");
    }
}

