/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.entities.Collision;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class ResourceElement
extends Element {
    private int statusCode = -1;
    private String statusDescription;
    private String errorCondition;
    private String extendedCondition;
    private String path;
    private ArrayList paths;
    private int pathsSize = 0;
    private ArrayList collisions;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$entities$ResourceElement == null ? (class$com$tssap$dtr$client$lib$protocol$entities$ResourceElement = ResourceElement.class$("com.tssap.dtr.client.lib.protocol.entities.ResourceElement")) : class$com$tssap$dtr$client$lib$protocol$entities$ResourceElement));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$entities$ResourceElement;

    public ResourceElement(String path) {
        super("response", "DAV:");
        this.path = path;
        this.pathsSize = 1;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public String getErrorCondition() {
        return this.errorCondition;
    }

    public String getExtendedCondition() {
        return this.extendedCondition;
    }

    public String getPath() {
        return this.path;
    }

    public int countPaths() {
        return this.pathsSize;
    }

    public String getPath(int index) {
        if (this.paths != null) {
            return (String)this.paths.get(index);
        }
        if (index == 0) {
            return this.path;
        }
        return null;
    }

    public Iterator getPaths() {
        if (this.paths != null) {
            return ((AbstractList)this.paths).iterator();
        }
        return Collections.singletonList(this.path).iterator();
    }

    public int countProperties() {
        return this.countChildren();
    }

    public PropertyElement getProperty(String propertyName) {
        return (PropertyElement)this.getChild(propertyName);
    }

    public PropertyElement getProperty(String propertyName, String namespaceURI) {
        return (PropertyElement)this.getChild(propertyName, namespaceURI);
    }

    public Iterator getProperties() {
        return this.getChildren();
    }

    public int countCollisions() {
        return this.collisions != null ? this.collisions.size() : 0;
    }

    public Collision getCollision(int index) {
        return this.collisions != null && index < this.collisions.size() ? (Collision)this.collisions.get(index) : null;
    }

    public Iterator getCollisions() {
        return this.collisions != null ? ((AbstractList)this.collisions).iterator() : null;
    }

    public void setStatus(String status) {
        Tokenizer tokenizer = new Tokenizer(status);
        String token = tokenizer.nextToken();
        if (token.startsWith("HTTP")) {
            token = tokenizer.nextToken();
        }
        try {
            this.statusCode = Integer.parseInt(token);
            this.statusDescription = tokenizer.lastToken();
        }
        catch (NumberFormatException e) {
            TRACE.catching("setStatus(String)", (Throwable)e);
        }
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public void setErrorCondition(String condition) {
        this.errorCondition = condition;
    }

    void setExtendedCondition(String description) {
        this.extendedCondition = description;
    }

    void addPath(String path) {
        if (this.paths == null) {
            this.paths = new ArrayList();
            this.paths.add(this.path);
        }
        this.paths.add(path);
        ++this.pathsSize;
    }

    void addCollision(Collision collision) {
        if (this.collisions == null) {
            this.collisions = new ArrayList();
        }
        this.collisions.add(collision);
    }

    void touchChildrenStatus(String status, String responseDescription, String extendedDescription) throws NumberFormatException {
        if (this.firstChild() != null) {
            Tokenizer tokenizer = new Tokenizer(status);
            String token = tokenizer.nextToken();
            if (token.startsWith("HTTP")) {
                token = tokenizer.nextToken();
            }
            int statusCode = Integer.parseInt(token);
            String statusDescription = tokenizer.lastToken();
            Iterator properties = this.getProperties();
            if (properties != null) {
                while (properties.hasNext()) {
                    PropertyElement property = (PropertyElement)properties.next();
                    if (property.getStatusCode() >= 0) continue;
                    property.setStatusCode(statusCode);
                    property.setStatusDescription(statusDescription);
                    property.setErrorCondition(responseDescription);
                    property.setExtendedCondition(extendedDescription);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

