/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Element {
    private String name;
    private String namespacePrefix;
    private String namespaceURI;
    private Object value;
    private Element next;
    private Element firstChild;
    private Element lastChild;
    private Element parent;
    private int count = 0;

    public Element(String qualifiedName, String namespaceURI) {
        this((Element)null, qualifiedName, namespaceURI);
    }

    public Element(String qualifiedName, String namespaceURI, String value) {
        this((Element)null, qualifiedName, namespaceURI);
        this.setValue(value);
    }

    public Element(Element parent, String qualifiedName, String namespaceURI) {
        this.parent = parent;
        int n = qualifiedName.indexOf(58);
        if (n > 0) {
            this.name = qualifiedName.substring(n + 1);
            this.namespacePrefix = qualifiedName.substring(0, n);
        } else {
            this.name = qualifiedName;
            this.namespacePrefix = null;
        }
        this.namespaceURI = namespaceURI;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.namespacePrefix != null ? this.namespacePrefix + ":" + this.name : this.name;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getNamespaceAttribute() {
        StringBuffer s = null;
        if (this.namespaceURI != null) {
            s = new StringBuffer("xmlns");
            if (this.namespacePrefix != null) {
                s.append(":").append(this.namespacePrefix);
            }
            s.append("=\"").append(this.namespaceURI).append("\"");
        }
        return s.toString();
    }

    public String getValue() {
        return this.value != null ? this.value.toString() : null;
    }

    public void setValue(String value) {
        this.removeChildren();
        this.value = value;
    }

    public Element getParent() {
        return this.parent;
    }

    public Element next() {
        return this.next;
    }

    public int countChildren() {
        return this.count;
    }

    public Element addChild(Element child) {
        if (this.lastChild != null) {
            this.lastChild = this.lastChild.next = child;
        } else {
            this.lastChild = this.firstChild = child;
            this.value = this;
        }
        ++this.count;
        return this.lastChild;
    }

    public Element addChild(String childName, String namespaceURI) {
        if (this.lastChild != null) {
            this.lastChild = this.lastChild.next = new Element(this, childName, namespaceURI);
        } else {
            this.lastChild = this.firstChild = new Element(this, childName, namespaceURI);
            this.value = this;
        }
        ++this.count;
        return this.lastChild;
    }

    public Element addChild(String childName, String value, String namespaceURI) {
        this.addChild(childName, namespaceURI);
        this.lastChild.setValue(value);
        return this.lastChild;
    }

    public Element firstChild() {
        return this.firstChild;
    }

    public Element lastChild() {
        return this.lastChild;
    }

    public Element getChild(String childName) {
        Element child = this.firstChild;
        int n = childName.indexOf(58);
        String simpleName = n > 0 ? childName.substring(n + 1) : childName;
        while (child != null) {
            if (simpleName.equals(child.name)) break;
            child = child.next;
        }
        return child;
    }

    public Element getChild(String childName, String namespaceURI) {
        Element child = this.firstChild;
        int n = childName.indexOf(58);
        String simpleName = n > 0 ? childName.substring(n + 1) : childName;
        while (child != null) {
            if (simpleName.equals(child.name) && namespaceURI.equals(child.namespaceURI)) break;
            child = child.next;
        }
        return child;
    }

    public String getChildValue(String childName) {
        Element child = this.getChild(childName);
        return child != null ? child.getValue() : null;
    }

    public String getChildValue(String childName, String namespaceURI) {
        Element child = this.getChild(childName, namespaceURI);
        return child != null ? child.getValue() : null;
    }

    public Iterator getChildren() {
        return new Iterator(){
            private Element child;
            {
                this.child = Element.this.firstChild;
            }

            public boolean hasNext() {
                return this.child != null;
            }

            public Object next() {
                if (this.child == null) {
                    throw new NoSuchElementException();
                }
                Element result = this.child;
                this.child = this.child.next;
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String[] getChildValues() {
        String[] values = null;
        Element child = this.firstChild;
        if (child != null) {
            values = new String[this.count];
            int i = 0;
            while (i < this.count) {
                values[i] = child.getValue();
                child = child.next;
                ++i;
            }
        }
        return values;
    }

    public void removeChildren() {
        Element child = this.firstChild;
        while (child != null) {
            Element next = child.next;
            child.next = null;
            child = next;
            next = null;
        }
        this.firstChild = null;
        this.lastChild = null;
        this.value = null;
    }

    public String toString() {
        if (this.firstChild == null) {
            return this.value != null ? Encoder.encodeXml((String)this.value) : null;
        }
        StringBuffer buf = new StringBuffer();
        Element child = this.firstChild;
        while (child != null) {
            String tagName = child.getQualifiedName();
            buf.append('<').append(tagName);
            String s = child.toString();
            if (s != null) {
                buf.append('>').append(s);
                buf.append("</").append(tagName).append('>');
            } else {
                buf.append("/>");
            }
            child = child.next;
        }
        return buf.toString();
    }
}

