/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ByteArrayEntity
extends ResponseEntityBase
implements IRequestEntity,
IResponseEntity {
    private byte[] buf;
    private int off;
    private int len;
    public static final String ENTITY_TYPE = "ByteArrayEntity";

    public ByteArrayEntity(byte[] buf, String contentType) {
        super(contentType);
        this.buf = buf;
        this.off = 0;
        this.len = buf.length;
    }

    public ByteArrayEntity(byte[] buf, int off, int len, String contentType) {
        super(contentType);
        this.buf = buf;
        this.off = off;
        this.len = len;
    }

    public ByteArrayEntity(IResponse response) throws HTTPException {
        super(response);
        try {
            this.read(response.getContent());
        }
        catch (IOException ex) {
            this.contentType = null;
            throw new HTTPException("Failed to read response body to buffer.", ex);
        }
    }

    public static boolean isByteArrayEntity(IResponseEntity entity) {
        return ENTITY_TYPE.equals(entity.getEntityType());
    }

    public static ByteArrayEntity valueOf(IResponseEntity entity) {
        return ByteArrayEntity.isByteArrayEntity(entity) ? (ByteArrayEntity)entity : null;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public long getContentLength() {
        return this.buf.length;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public String calculateMD5() throws NoSuchAlgorithmException {
        if (this.buf != null) {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            MD5.update(this.buf, this.off, this.len);
            byte[] digest = MD5.digest();
            return Encoder.toHexString(digest);
        }
        return null;
    }

    public byte[] getContent() {
        return this.buf;
    }

    public String getContent(String enc) throws UnsupportedEncodingException {
        return this.buf != null ? new String(this.buf, enc) : null;
    }

    public void read(IResponseStream source) throws IOException {
        ByteArrayOutputStream dest;
        int cnt;
        if (source != null && (cnt = source.read(dest = new ByteArrayOutputStream())) > 0) {
            while (cnt > 0) {
                cnt = source.read(dest);
            }
            this.buf = dest.toByteArray();
            this.off = 0;
            this.len = this.buf.length;
        }
    }

    public void write(IRequestStream destination) throws IOException {
        if (this.buf != null) {
            destination.write(this.buf, this.off, this.len);
        }
    }

    public void reset() {
    }

    public boolean supportsReset() {
        return true;
    }
}

