/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.simplescenario.generation.servicecontroller;

import com.sap.ide.metamodel.common.CommonDevelopmentObject;
import com.sap.ide.metamodel.common.template.TemplateInstance;
import com.sap.ide.metamodel.common.template.TemplateMarker;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerMethod;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.tools.core.patternfwk.internal.PatternFwkPlugin;
import com.sap.ide.tools.core.template.service.GenerationPositionEnum;
import com.sap.ide.tools.core.template.service.IGenerationFacade;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.tools.core.template.service.ITemplateGeneration;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.template.simplescenario.generation.servicecontroller.IModelData;

public class ModelGeneration
implements ITemplateGeneration {
    public void generateMetaDataObjects(ITemplateData templateData, DevelopmentObject containingObject) {
        if (containingObject != null && templateData != null && templateData instanceof IModelData) {
            IModelData modelData = (IModelData)templateData;
            if (modelData.getTemporaryMetaModel() != null) {
                try {
                    modelData.getTemporaryMetaModel().rollbackChanges();
                    modelData.getTemporaryMetaModel().shutDown();
                }
                catch (LoadException le) {
                    PatternFwkPlugin.internalError(this.getClass(), (String)"generateMetaDataObjects(ITemplateData templateData, DevelopmentObject containingObject)", (String)le.getMessage(), (Throwable)le, (boolean)true);
                }
                catch (MetamodelException me) {
                    PatternFwkPlugin.internalError(this.getClass(), (String)"generateMetaDataObjects(ITemplateData templateData, DevelopmentObject containingObject)", (String)me.getMessage(), (Throwable)me, (boolean)true);
                }
            }
            TemplateInstance templateInstance = modelData.getTemplateInstance();
            TemplateMarker marker = null;
            if (containingObject instanceof Component) {
                Component component = (Component)containingObject;
                try {
                    Controller customController = this.createController(component, modelData.getCustomControllerName(), ControllerTypeEnum.CUSTOM);
                    modelData.setController(customController);
                    modelData.bindModel();
                    marker = templateInstance.createTemplateMarker("CONTROLLER_" + customController.getName());
                    marker.setRole("customcontroller");
                    marker.setParticipant((CommonDevelopmentObject)customController);
                    String methodName = modelData.getMethodName();
                    ControllerMethod method = null;
                    if (methodName != null && !methodName.equals("")) {
                        method = customController.createMethod(methodName);
                        marker = templateInstance.createTemplateMarker("METHOD_" + methodName);
                        marker.setRole("controllermethod");
                        marker.setParticipant((CommonDevelopmentObject)method);
                    }
                }
                catch (CreateException e) {
                    PatternFwkPlugin.internalError(this.getClass(), (String)"generateMetaDataObjects(ITemplateData templateData, DevelopmentObject containingObject)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                }
            } else if (containingObject instanceof Controller || containingObject instanceof View) {
                Controller customController = modelData.getController();
                try {
                    modelData.bindModel();
                    marker = templateInstance.createTemplateMarker("CONTROLLER_" + customController.getName());
                    marker.setRole("customcontroller");
                    marker.setParticipant((CommonDevelopmentObject)customController);
                    String methodName = modelData.getMethodName();
                    ControllerMethod method = null;
                    if (methodName != null && !methodName.equals("")) {
                        method = customController.createMethod(methodName);
                        marker = templateInstance.createTemplateMarker("METHOD_" + methodName);
                        marker.setRole("controllermethod");
                        marker.setParticipant((CommonDevelopmentObject)method);
                    }
                }
                catch (CreateException e) {
                    PatternFwkPlugin.internalError(this.getClass(), (String)"generateMetaDataObjects(ITemplateData templateData, DevelopmentObject containingObject)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                }
            }
        }
    }

    private Controller createController(Component componentIF, String name, ControllerTypeEnum type) throws CreateException {
        String packageName = "";
        String className = name;
        if (className.lastIndexOf(46) >= 0) {
            packageName = className.substring(0, className.lastIndexOf(46));
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        Controller controller = componentIF.createController(componentIF.getPackage(), className);
        this.completeCreatedController(controller, name, type);
        return controller;
    }

    private void completeCreatedController(Controller controller, String name, ControllerTypeEnum type) throws CreateException {
        controller.setType(type);
        controller.setVisibility(VisibilityEnum.PUBLIC);
        controller.createContext();
        ContextValueNode rootNode = controller.getContext();
        rootNode.setSingleton(true);
        rootNode.setCardinality(CardinalityEnum._1_1);
        rootNode.setSelection(CardinalityEnum._1_1);
    }

    public void generateCoding(IGenerationFacade facade) {
        if (facade.getTemplateData() instanceof IModelData) {
            IModelData modelData = (IModelData)facade.getTemplateData();
            String methodName = modelData.getMethodName();
            Controller customController = modelData.getController();
            if (customController != null) {
                Object code = null;
                Method controllerMethod = null;
                StringBuffer initBuffer = new StringBuffer();
                initBuffer.append("\twdContext.node");
                initBuffer.append(this.getHungarianNotation(modelData.getModelNode().getName()));
                initBuffer.append("().bind(new ");
                initBuffer.append(modelData.getModelClass().getName());
                initBuffer.append("());");
                facade.insert((DevelopmentObject)customController, GenerationPositionEnum.INITBEFORE, initBuffer.toString());
                if (methodName != null) {
                    controllerMethod = customController.getMethod(methodName);
                    ContextModelNode outputNode = this.getOutputClassName(customController, modelData.getModelNode().getName());
                    if (controllerMethod != null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("\tIWDMessageManager manager = wdComponentAPI.getMessageManager();\n");
                        buffer.append("\ttry{\n");
                        buffer.append("\t\twdContext.current");
                        buffer.append(this.getHungarianNotation(modelData.getModelNode().getName()));
                        buffer.append("Element().modelObject().execute();\n");
                        if (outputNode != null) {
                            buffer.append("\t\twdContext.node");
                            buffer.append(this.getHungarianNotation(outputNode.getName()));
                            buffer.append("().invalidate();\n");
                            buffer.append(this.getInvalidateText(outputNode));
                        }
                        buffer.append("\t} catch(" + this.getException(modelData) + " ce) {\n");
                        buffer.append("\t\tmanager.reportException(ce.getMessage(), false);\n");
                        buffer.append("\t}");
                        facade.insert((DevelopmentObject)controllerMethod, GenerationPositionEnum.BEFORE, buffer.toString());
                    }
                }
            }
        }
    }

    private String getException(IModelData modelData) {
        if (modelData != null) {
            Model model = modelData.getModelClass().getModel();
            if (MetamodelServices.hasModelTypeDynamicRfcAdapter((Model)model)) {
                return "WDDynamicRFCExecuteException";
            }
            if (MetamodelServices.hasModelTypeRfcAdapter((Model)model)) {
                return "WDExecuteRFCException";
            }
            if (MetamodelServices.hasModelTypeWebServiceModel((Model)model)) {
                return "Exception";
            }
        }
        return "Execption";
    }

    private String getInvalidateText(ContextModelNode modelNode) {
        if (modelNode != null && modelNode.getSupplyingRelationRole().getName().equalsIgnoreCase("response")) {
            StringBuffer buffer = new StringBuffer();
            this.getAllChildNodes(modelNode, buffer);
            return buffer.toString();
        }
        return "";
    }

    private void getAllChildNodes(ContextModelNode modelNode, StringBuffer buffer) {
        AbstractContextNode[] childnodes = modelNode.getChildNodes();
        if (childnodes != null) {
            int i = 0;
            while (i < childnodes.length) {
                buffer.append("\t\twdContext.node");
                buffer.append(this.getHungarianNotation(childnodes[i].getName()));
                buffer.append("().invalidate();\n");
                this.getAllChildNodes((ContextModelNode)childnodes[i], buffer);
                ++i;
            }
        }
    }

    private ContextModelNode getOutputClassName(Controller controller, String modelNodeName) {
        if (controller != null && modelNodeName != null) {
            ContextValueNode context = controller.getContext();
            ContextModelNode modelNode = (ContextModelNode)context.getChildNode(modelNodeName);
            ContextModelNode outputNode = this.getOutputNode(modelNode);
            return outputNode;
        }
        return null;
    }

    private ContextModelNode getOutputNode(ContextModelNode modelNode) {
        ContextModelNode node = null;
        if (modelNode != null) {
            AbstractContextNode[] childNodes = modelNode.getChildNodes();
            ContextModelNode childNode = null;
            if (childNodes != null) {
                int m = 0;
                m = 0;
                while (m < childNodes.length) {
                    childNode = (ContextModelNode)childNodes[m];
                    if (childNode != null && childNode.getSupplyingRelationRole() != null && (childNode.getSupplyingRelationRole().getName().equalsIgnoreCase("Response") || childNode.getSupplyingRelationRole().getName().equalsIgnoreCase("Output"))) {
                        return childNode;
                    }
                    ++m;
                }
            }
        }
        return node;
    }

    private String getHungarianNotation(String name) {
        String newName = null;
        if (name != null) {
            char[] chars = name.trim().toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            newName = new String(chars);
        }
        return newName;
    }

    public void finish(ITemplateData templateData) {
    }

    public boolean check(ITemplateData templateData, DevelopmentObject object) {
        return true;
    }

    public MainDevelopmentObject[] getAffectedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return new MainDevelopmentObject[]{object.getMDO()};
    }

    public MainDevelopmentObject[] getCreatedMDOs(ITemplateData templateData, DevelopmentObject object) {
        if (object instanceof Component && templateData instanceof IModelData) {
            return new MainDevelopmentObject[]{((IModelData)templateData).getController()};
        }
        return null;
    }

    public MainDevelopmentObject[] getDeletedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return null;
    }
}

